/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.PostConstructCallback;
import org.eclipse.jetty.plus.annotation.PreDestroyCallback;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.Link;
import org.eclipse.jetty.plus.jndi.NamingEntry;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.Fragment;
import org.eclipse.jetty.webapp.IterativeDescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlProcessor;
import org.eclipse.jetty.xml.XmlParser;

public class PlusDescriptorProcessor
extends IterativeDescriptorProcessor {
    protected WebAppContext _context;
    protected WebXmlProcessor _processor;

    public PlusDescriptorProcessor(WebXmlProcessor processor) {
        this._processor = processor;
        this._context = this._processor.getContext();
        try {
            this.registerVisitor("env-entry", this.getClass().getDeclaredMethod("visitEnvEntry", __signature));
            this.registerVisitor("resource-ref", this.getClass().getDeclaredMethod("visitResourceRef", __signature));
            this.registerVisitor("resource-env-ref", this.getClass().getDeclaredMethod("visitResourceEnvRef", __signature));
            this.registerVisitor("message-destination-ref", this.getClass().getDeclaredMethod("visitMessageDestinationRef", __signature));
            this.registerVisitor("post-construct", this.getClass().getDeclaredMethod("visitPostConstruct", __signature));
            this.registerVisitor("pre-destroy", this.getClass().getDeclaredMethod("visitPreDestroy", __signature));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void end() {
    }

    public void visitEnvEntry(Descriptor descriptor, XmlParser.Node node) throws Exception {
        String name = node.getString("env-entry-name", false, true);
        String type = node.getString("env-entry-type", false, true);
        String valueStr = node.getString("env-entry-value", false, true);
        if (valueStr == null || valueStr.equals("")) {
            Log.warn("No value for env-entry-name " + name);
            return;
        }
        WebXmlProcessor.Origin o = this._processor.getOrigin("env-entry." + name);
        switch (o) {
            case NotSet: {
                this._processor.setOrigin("env-entry." + name, descriptor);
                this.addInjection(descriptor, node, name, TypeUtil.fromName(type));
                Object value = TypeUtil.valueOf(type, valueStr);
                this.bindEnvEntry(name, value);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof Fragment)) {
                    this._processor.setOrigin("env-entry." + name, descriptor);
                    this.addInjection(descriptor, node, name, TypeUtil.fromName(type));
                    Object value = TypeUtil.valueOf(type, valueStr);
                    this.bindEnvEntry(name, value);
                    break;
                }
                Descriptor d = this._processor.getOriginDescriptor("env-entry." + name + ".injection");
                if (d != null && !(d instanceof Fragment)) break;
                this.addInjection(descriptor, node, name, TypeUtil.fromName(type));
                break;
            }
            case WebFragment: {
                throw new IllegalStateException("Conflicting env-entry " + name + " in " + descriptor.getResource());
            }
        }
    }

    public void visitResourceRef(Descriptor descriptor, XmlParser.Node node) throws Exception {
        String jndiName = node.getString("res-ref-name", false, true);
        String type = node.getString("res-type", false, true);
        String auth = node.getString("res-auth", false, true);
        String shared = node.getString("res-sharing-scope", false, true);
        WebXmlProcessor.Origin o = this._processor.getOrigin("resource-ref." + jndiName);
        switch (o) {
            case NotSet: {
                this._processor.setOrigin("resource-ref." + jndiName, descriptor);
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = this._context.loadClass(type);
                }
                this.addInjection(descriptor, node, jndiName, typeClass);
                this.bindResourceRef(jndiName, typeClass);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof Fragment)) {
                    this._processor.setOrigin("resource-ref." + jndiName, descriptor);
                    Class<?> typeClass = TypeUtil.fromName(type);
                    if (typeClass == null) {
                        typeClass = this._context.loadClass(type);
                    }
                    this.addInjection(descriptor, node, jndiName, typeClass);
                    this.bindResourceRef(jndiName, typeClass);
                    break;
                }
                Descriptor d = this._processor.getOriginDescriptor("resource-ref." + jndiName + ".injection");
                if (d != null && !(d instanceof Fragment)) break;
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = this._context.loadClass(type);
                }
                this.addInjection(descriptor, node, jndiName, TypeUtil.fromName(type));
                break;
            }
            case WebFragment: {
                throw new IllegalStateException("Conflicting resource-ref " + jndiName + " in " + descriptor.getResource());
            }
        }
    }

    public void visitResourceEnvRef(Descriptor descriptor, XmlParser.Node node) throws Exception {
        String jndiName = node.getString("resource-env-ref-name", false, true);
        String type = node.getString("resource-env-ref-type", false, true);
        WebXmlProcessor.Origin o = this._processor.getOrigin("resource-env-ref." + jndiName);
        switch (o) {
            case NotSet: {
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = this._context.loadClass(type);
                }
                this.addInjection(descriptor, node, jndiName, typeClass);
                this.bindResourceEnvRef(jndiName, typeClass);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof Fragment)) {
                    this._processor.setOrigin("resource-env-ref." + jndiName, descriptor);
                    Class<?> typeClass = TypeUtil.fromName(type);
                    if (typeClass == null) {
                        typeClass = this._context.loadClass(type);
                    }
                    this.addInjection(descriptor, node, jndiName, typeClass);
                    this.bindResourceEnvRef(jndiName, typeClass);
                    break;
                }
                Descriptor d = this._processor.getOriginDescriptor("resource-env-ref." + jndiName + ".injection");
                if (d != null && !(d instanceof Fragment)) break;
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = this._context.loadClass(type);
                }
                this.addInjection(descriptor, node, jndiName, typeClass);
                break;
            }
            case WebFragment: {
                throw new IllegalStateException("Conflicting resource-env-ref " + jndiName + " in " + descriptor.getResource());
            }
        }
    }

    public void visitMessageDestinationRef(Descriptor descriptor, XmlParser.Node node) throws Exception {
        String jndiName = node.getString("message-destination-ref-name", false, true);
        String type = node.getString("message-destination-type", false, true);
        String usage = node.getString("message-destination-usage", false, true);
        WebXmlProcessor.Origin o = this._processor.getOrigin("message-destination-ref." + jndiName);
        switch (o) {
            case NotSet: {
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = this._context.loadClass(type);
                }
                this.addInjection(descriptor, node, jndiName, typeClass);
                this.bindMessageDestinationRef(jndiName, typeClass);
                this._processor.setOrigin("message-destination-ref." + jndiName, descriptor);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof Fragment)) {
                    Class<?> typeClass = TypeUtil.fromName(type);
                    if (typeClass == null) {
                        typeClass = this._context.loadClass(type);
                    }
                    this.addInjection(descriptor, node, jndiName, typeClass);
                    this.bindMessageDestinationRef(jndiName, typeClass);
                    this._processor.setOrigin("message-destination-ref." + jndiName, descriptor);
                    break;
                }
                Descriptor d = this._processor.getOriginDescriptor("message-destination-ref." + jndiName + ".injection");
                if (d != null && !(d instanceof Fragment)) break;
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = this._context.loadClass(type);
                }
                this.addInjection(descriptor, node, jndiName, typeClass);
                break;
            }
            case WebFragment: {
                throw new IllegalStateException("Conflicting message-destination-ref " + jndiName + " in " + descriptor.getResource());
            }
        }
    }

    public void visitPostConstruct(Descriptor descriptor, XmlParser.Node node) {
        String className = node.getString("lifecycle-callback-class", false, true);
        String methodName = node.getString("lifecycle-callback-method", false, true);
        if (className == null || className.equals("")) {
            Log.warn("No lifecycle-callback-class specified");
            return;
        }
        if (methodName == null || methodName.equals("")) {
            Log.warn("No lifecycle-callback-method specified for class " + className);
            return;
        }
        LifeCycleCallbackCollection callbacks = (LifeCycleCallbackCollection)this._context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
        WebXmlProcessor.Origin o = this._processor.getOrigin("post-construct");
        switch (o) {
            case NotSet: {
                this._processor.setOrigin("post-construct", descriptor);
                try {
                    Class<?> clazz = this._context.loadClass(className);
                    PostConstructCallback callback = new PostConstructCallback();
                    callback.setTarget(clazz, methodName);
                    callbacks.add(callback);
                }
                catch (ClassNotFoundException e) {
                    Log.warn("Couldn't load post-construct target class " + className);
                }
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof Fragment) break;
                try {
                    Class<?> clazz = this._context.loadClass(className);
                    PostConstructCallback callback = new PostConstructCallback();
                    callback.setTarget(clazz, methodName);
                    callbacks.add(callback);
                }
                catch (ClassNotFoundException e) {
                    Log.warn("Couldn't load post-construct target class " + className);
                }
                break;
            }
            case WebFragment: {
                try {
                    Class<?> clazz = this._context.loadClass(className);
                    PostConstructCallback callback = new PostConstructCallback();
                    callback.setTarget(clazz, methodName);
                    callbacks.add(callback);
                    break;
                }
                catch (ClassNotFoundException e) {
                    Log.warn("Couldn't load post-construct target class " + className);
                }
            }
        }
    }

    public void visitPreDestroy(Descriptor descriptor, XmlParser.Node node) {
        String className = node.getString("lifecycle-callback-class", false, true);
        String methodName = node.getString("lifecycle-callback-method", false, true);
        if (className == null || className.equals("")) {
            Log.warn("No lifecycle-callback-class specified for pre-destroy");
            return;
        }
        if (methodName == null || methodName.equals("")) {
            Log.warn("No lifecycle-callback-method specified for pre-destroy class " + className);
            return;
        }
        LifeCycleCallbackCollection callbacks = (LifeCycleCallbackCollection)this._context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
        WebXmlProcessor.Origin o = this._processor.getOrigin("pre-destroy");
        switch (o) {
            case NotSet: {
                this._processor.setOrigin("pre-destroy", descriptor);
                try {
                    Class<?> clazz = this._context.loadClass(className);
                    PreDestroyCallback callback = new PreDestroyCallback();
                    callback.setTarget(clazz, methodName);
                    callbacks.add(callback);
                }
                catch (ClassNotFoundException e) {
                    Log.warn("Couldn't load pre-destory target class " + className);
                }
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof Fragment) break;
                try {
                    Class<?> clazz = this._context.loadClass(className);
                    PreDestroyCallback callback = new PreDestroyCallback();
                    callback.setTarget(clazz, methodName);
                    callbacks.add(callback);
                }
                catch (ClassNotFoundException e) {
                    Log.warn("Couldn't load pre-destory target class " + className);
                }
                break;
            }
            case WebFragment: {
                try {
                    Class<?> clazz = this._context.loadClass(className);
                    PreDestroyCallback callback = new PreDestroyCallback();
                    callback.setTarget(clazz, methodName);
                    callbacks.add(callback);
                    break;
                }
                catch (ClassNotFoundException e) {
                    Log.warn("Couldn't load pre-destory target class " + className);
                }
            }
        }
    }

    public void addInjection(Descriptor descriptor, XmlParser.Node node, String jndiName, Class valueClass) {
        Iterator itor = node.iterator("injection-target");
        while (itor.hasNext()) {
            XmlParser.Node injectionNode = (XmlParser.Node)itor.next();
            String targetClassName = injectionNode.getString("injection-target-class", false, true);
            String targetName = injectionNode.getString("injection-target-name", false, true);
            if (targetClassName == null || targetClassName.equals("")) {
                Log.warn("No classname found in injection-target");
                continue;
            }
            if (targetName == null || targetName.equals("")) {
                Log.warn("No field or method name in injection-target");
                continue;
            }
            InjectionCollection injections = (InjectionCollection)this._context.getAttribute("org.eclipse.jetty.injectionCollection");
            try {
                Class<?> clazz = this._context.loadClass(targetClassName);
                Injection injection = new Injection();
                injection.setJndiName(jndiName);
                injection.setTarget(clazz, targetName, valueClass);
                injections.add(injection);
                if (this._processor.getOriginDescriptor(node.getTag() + "." + jndiName + ".injection") != null) continue;
                this._processor.setOrigin(node.getTag() + "." + jndiName + ".injection", descriptor);
            }
            catch (ClassNotFoundException e) {
                Log.warn("Couldn't load injection target class " + targetClassName);
            }
        }
    }

    public void bindEnvEntry(String name, Object value) throws Exception {
        InitialContext ic = null;
        boolean bound = false;
        ic = new InitialContext();
        try {
            NamingEntry ne = (NamingEntry)ic.lookup("java:comp/env/" + NamingEntryUtil.makeNamingEntryName(ic.getNameParser(""), name));
            if (ne != null && ne instanceof EnvEntry) {
                EnvEntry ee = (EnvEntry)ne;
                bound = ee.isOverrideWebXml();
            }
        }
        catch (NameNotFoundException e) {
            bound = false;
        }
        if (!bound) {
            Context envCtx = (Context)ic.lookup("java:comp/env");
            NamingUtil.bind(envCtx, name, value);
        }
    }

    public void bindResourceRef(String name, Class typeClass) throws Exception {
        this.bindEntry(name, typeClass);
    }

    public void bindResourceEnvRef(String name, Class typeClass) throws Exception {
        this.bindEntry(name, typeClass);
    }

    public void bindMessageDestinationRef(String name, Class typeClass) throws Exception {
        this.bindEntry(name, typeClass);
    }

    protected void bindEntry(String name, Class typeClass) throws Exception {
        String nameInEnvironment = name;
        boolean bound = false;
        HandlerWrapper scope = this._context;
        NamingEntry ne = NamingEntryUtil.lookupNamingEntry(scope, name);
        if (ne != null && ne instanceof Link) {
            nameInEnvironment = (String)((Link)ne).getObjectToBind();
            Link l = (Link)ne;
        }
        if (bound = NamingEntryUtil.bindToENC(scope = this._context, name, nameInEnvironment)) {
            return;
        }
        scope = this._context.getServer();
        bound = NamingEntryUtil.bindToENC(scope, name, nameInEnvironment);
        if (bound) {
            return;
        }
        bound = NamingEntryUtil.bindToENC(null, name, nameInEnvironment);
        if (bound) {
            return;
        }
        nameInEnvironment = typeClass.getName() + "/default";
        NamingEntry defaultNE = NamingEntryUtil.lookupNamingEntry(this._context.getServer(), nameInEnvironment);
        if (defaultNE == null) {
            defaultNE = NamingEntryUtil.lookupNamingEntry(null, nameInEnvironment);
        }
        if (defaultNE == null) {
            throw new IllegalStateException("Nothing to bind for name " + nameInEnvironment);
        }
        defaultNE.bindToENC(name);
    }
}

