/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.ShutdownThread;

public class ConnectorServer
extends AbstractLifeCycle {
    JMXConnectorServer _connectorServer;

    public ConnectorServer(JMXServiceURL serviceURL, String name) throws Exception {
        this(serviceURL, null, name);
    }

    public ConnectorServer(JMXServiceURL serviceURL, Map<String, ?> environment, String name) throws Exception {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this._connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(serviceURL, environment, mbeanServer);
        mbeanServer.registerMBean(this._connectorServer, new ObjectName(name));
    }

    @Override
    public void doStart() throws Exception {
        this._connectorServer.start();
        ShutdownThread.register(0, this);
        Log.info("JMX Remote URL: {}", this._connectorServer.getAddress().toString());
    }

    @Override
    public void doStop() throws Exception {
        ShutdownThread.deregister(this);
        this._connectorServer.stop();
    }
}

