/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.jaspi;

import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.servlet.ServletContext;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultAuthenticatorFactory;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.jaspi.JaspiAuthenticator;
import org.eclipse.jetty.security.jaspi.ServletCallbackHandler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;

public class JaspiAuthenticatorFactory
extends DefaultAuthenticatorFactory {
    private static String MESSAGE_LAYER = "HTTP";
    private Subject _serviceSubject;
    private String _serverName;

    public Subject getServiceSubject() {
        return this._serviceSubject;
    }

    public void setServiceSubject(Subject serviceSubject) {
        this._serviceSubject = serviceSubject;
    }

    public String getServerName() {
        return this._serverName;
    }

    public void setServerName(String serverName) {
        this._serverName = serverName;
    }

    public Authenticator getAuthenticator(Server server, ServletContext context, Authenticator.Configuration configuration, IdentityService identityService, LoginService loginService) {
        JaspiAuthenticator authenticator = null;
        try {
            ServletCallbackHandler servletCallbackHandler;
            ServerAuthConfig serverAuthConfig;
            AuthConfigFactory authConfigFactory = AuthConfigFactory.getFactory();
            RegistrationListener listener = new RegistrationListener(){

                public void notify(String layer, String appContext) {
                }
            };
            Subject serviceSubject = this.findServiceSubject(server);
            String serverName = this.findServerName(server, serviceSubject);
            String appContext = serverName + " " + context.getContextPath();
            AuthConfigProvider authConfigProvider = authConfigFactory.getConfigProvider(MESSAGE_LAYER, appContext, listener);
            if (authConfigProvider != null && (serverAuthConfig = authConfigProvider.getServerAuthConfig(MESSAGE_LAYER, appContext, (CallbackHandler)(servletCallbackHandler = new ServletCallbackHandler(loginService)))) != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                for (String key : configuration.getInitParameterNames()) {
                    map.put(key, configuration.getInitParameter(key));
                }
                authenticator = new JaspiAuthenticator(serverAuthConfig, map, servletCallbackHandler, serviceSubject, configuration.isLazy(), identityService);
            }
        }
        catch (AuthException e) {
            Log.warn(e);
        }
        return authenticator;
    }

    protected Subject findServiceSubject(Server server) {
        if (this._serviceSubject != null) {
            return this._serviceSubject;
        }
        List<Subject> subjects = server.getBeans(Subject.class);
        if (subjects.size() > 0) {
            return subjects.get(0);
        }
        return null;
    }

    protected String findServerName(Server server, Subject subject) {
        Set<Principal> principals;
        if (this._serverName != null) {
            return this._serverName;
        }
        if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
            return principals.iterator().next().getName();
        }
        return "server";
    }
}

