/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.common;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketSession;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTracker
extends AbstractLifeCycle
implements JakartaWebSocketSessionListener {
    private static final Logger LOG = LoggerFactory.getLogger(SessionTracker.class);
    private final CopyOnWriteArraySet<JakartaWebSocketSession> sessions = new CopyOnWriteArraySet();

    public Set<Session> getSessions() {
        return Collections.unmodifiableSet(this.sessions);
    }

    @Override
    public void onJakartaWebSocketSessionOpened(JakartaWebSocketSession session) {
        this.sessions.add(session);
    }

    @Override
    public void onJakartaWebSocketSessionClosed(JakartaWebSocketSession session) {
        this.sessions.remove(session);
    }

    @Override
    protected void doStop() throws Exception {
        for (Session session : this.sessions) {
            try {
                session.close(new CloseReason(CloseReason.CloseCodes.GOING_AWAY, "Container being shut down"));
            }
            catch (IOException e) {
                LOG.trace("IGNORED", (Throwable)e);
            }
        }
        super.doStop();
    }
}

