/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.client.internal;

import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.HandshakeResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.websocket.core.client.UpgradeListener;

public class JsrUpgradeListener
implements UpgradeListener {
    private ClientEndpointConfig.Configurator configurator;

    public JsrUpgradeListener(ClientEndpointConfig.Configurator configurator) {
        this.configurator = configurator;
    }

    @Override
    public void onHandshakeRequest(HttpRequest request) {
        if (this.configurator == null) {
            return;
        }
        HttpFields.Mutable fields = request.getHeaders();
        HashMap<String, List<String>> originalHeaders = new HashMap<String, List<String>>();
        fields.forEach(field -> {
            originalHeaders.putIfAbsent(field.getName(), new ArrayList());
            List values = (List)originalHeaders.get(field.getName());
            Collections.addAll(values, field.getValues());
        });
        this.configurator.beforeRequest(originalHeaders);
        fields.clear();
        originalHeaders.forEach(fields::put);
    }

    @Override
    public void onHandshakeResponse(HttpRequest request, HttpResponse response) {
        if (this.configurator == null) {
            return;
        }
        HandshakeResponse handshakeResponse = () -> {
            HashMap ret = new HashMap();
            response.getHeaders().forEach(field -> {
                ret.putIfAbsent(field.getName(), new ArrayList());
                List values = (List)ret.get(field.getName());
                Collections.addAll(values, field.getValues());
            });
            return ret;
        };
        this.configurator.afterResponse(handshakeResponse);
    }
}

