/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.internal;

import org.eclipse.jetty.websocket.core.OpCode;
import org.eclipse.jetty.websocket.core.exception.ProtocolException;

public class FrameSequence {
    private byte state = (byte)-1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(byte opcode, boolean fin) throws ProtocolException {
        FrameSequence frameSequence = this;
        synchronized (frameSequence) {
            if (this.state == 8) {
                throw new ProtocolException(OpCode.name(opcode) + " after CLOSE");
            }
            switch (opcode) {
                case -1: {
                    throw new ProtocolException("UNDEFINED OpCode: " + OpCode.name(opcode));
                }
                case 0: {
                    if (this.state == -1) {
                        throw new ProtocolException("CONTINUATION after fin==true");
                    }
                    if (fin) {
                        this.state = (byte)-1;
                    }
                    return;
                }
                case 8: {
                    this.state = (byte)8;
                    return;
                }
                case 9: 
                case 10: {
                    return;
                }
            }
            if (this.state != -1) {
                throw new ProtocolException("DataFrame before fin==true");
            }
            if (!fin) {
                this.state = opcode;
            }
            return;
        }
    }
}

