/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.client;

import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpUpgrader;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.WebSocketConstants;
import org.eclipse.jetty.websocket.core.client.ClientUpgradeRequest;

public class HttpUpgraderOverHTTP2
implements HttpUpgrader {
    private static final PreEncodedHttpField WS_VERSION_FIELD = new PreEncodedHttpField(HttpHeader.SEC_WEBSOCKET_VERSION, WebSocketConstants.SPEC_VERSION_STRING);
    private final ClientUpgradeRequest clientUpgradeRequest;

    public HttpUpgraderOverHTTP2(ClientUpgradeRequest clientUpgradeRequest) {
        this.clientUpgradeRequest = clientUpgradeRequest;
    }

    @Override
    public void prepare(HttpRequest request) {
        request.upgradeProtocol("websocket").method(HttpMethod.CONNECT).headers(headers -> headers.put(WS_VERSION_FIELD));
        this.clientUpgradeRequest.requestComplete();
    }

    @Override
    public void upgrade(HttpResponse response, EndPoint endPoint, Callback callback) {
        try {
            this.clientUpgradeRequest.upgrade(response, endPoint);
            callback.succeeded();
        }
        catch (Throwable x) {
            callback.failed(x);
        }
    }
}

