/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.client;

import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.websocket.core.client.XmlHttpClientProvider;
import org.slf4j.LoggerFactory;

public interface HttpClientProvider {
    public static HttpClient get() {
        try {
            XmlHttpClientProvider xmlProvider = new XmlHttpClientProvider();
            HttpClient client = xmlProvider.newHttpClient();
            if (client != null) {
                return client;
            }
        }
        catch (Throwable x) {
            LoggerFactory.getLogger(HttpClientProvider.class).trace("IGNORED", x);
        }
        return HttpClientProvider.newDefaultHttpClient();
    }

    private static HttpClient newDefaultHttpClient() {
        HttpClient client = new HttpClient();
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("WebSocketClient@" + client.hashCode());
        client.setExecutor(threadPool);
        return client;
    }

    default public HttpClient newHttpClient() {
        return HttpClientProvider.newDefaultHttpClient();
    }
}

