/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;

public class DelegatedJettyClientUpgradeResponse
implements UpgradeResponse {
    private HttpResponse delegate;

    public DelegatedJettyClientUpgradeResponse(HttpResponse response) {
        this.delegate = response;
    }

    @Override
    public String getAcceptedSubProtocol() {
        return this.delegate.getHeaders().get(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
    }

    @Override
    public String getHeader(String name) {
        return this.delegate.getHeaders().get(name);
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.delegate.getHeaders().getFieldNamesCollection();
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.delegate.getHeaders().getValuesList(name);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return null;
    }

    @Override
    public int getStatusCode() {
        return this.delegate.getStatus();
    }

    @Override
    public void addHeader(String name, String value) {
    }

    @Override
    public void sendForbidden(String message) throws IOException {
    }

    @Override
    public void setAcceptedSubProtocol(String protocol) {
    }

    @Override
    public List<ExtensionConfig> getExtensions() {
        List<String> rawExtensions = this.delegate.getHeaders().getValuesList(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (rawExtensions == null || rawExtensions.isEmpty()) {
            return Collections.emptyList();
        }
        return rawExtensions.stream().map(parameterizedName -> ExtensionConfig.parse(parameterizedName)).collect(Collectors.toList());
    }

    @Override
    public void setExtensions(List<ExtensionConfig> extensions) {
    }

    @Override
    public void setHeader(String name, String value) {
    }

    @Override
    public void setStatusCode(int statusCode) {
    }
}

