/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.impl;

import java.net.HttpCookie;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.core.client.ClientUpgradeRequest;

public class DelegatedJettyClientUpgradeRequest
implements UpgradeRequest {
    private final ClientUpgradeRequest delegate;
    private SocketAddress localSocketAddress;
    private SocketAddress remoteSocketAddress;

    public DelegatedJettyClientUpgradeRequest(ClientUpgradeRequest delegate) {
        this.delegate = delegate;
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.delegate.getCookies();
    }

    @Override
    public String getHeader(String name) {
        return this.delegate.getHeaders().get(name);
    }

    @Override
    public int getHeaderInt(String name) {
        HttpField field = this.delegate.getHeaders().getField(name);
        if (field == null) {
            return -1;
        }
        return field.getIntValue();
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.delegate.getHeaders().getValuesList(name);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return null;
    }

    @Override
    public String getHost() {
        return this.delegate.getHost();
    }

    @Override
    public String getHttpVersion() {
        return this.delegate.getVersion().toString();
    }

    public void configure(EndPoint endpoint) {
        this.localSocketAddress = endpoint.getLocalAddress();
        this.remoteSocketAddress = endpoint.getRemoteAddress();
    }

    @Override
    public String getMethod() {
        return this.delegate.getMethod();
    }

    @Override
    public String getOrigin() {
        return this.delegate.getHeaders().get(HttpHeader.ORIGIN);
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        if (this.getQueryString() == null) {
            return Collections.emptyMap();
        }
        MultiMap<String> params = new MultiMap<String>();
        UrlEncoded.decodeTo(this.getQueryString(), params, StandardCharsets.UTF_8);
        return params;
    }

    @Override
    public String getProtocolVersion() {
        return this.delegate.getHeaders().get(HttpHeader.SEC_WEBSOCKET_VERSION);
    }

    @Override
    public String getQueryString() {
        return this.delegate.getQuery();
    }

    @Override
    public URI getRequestURI() {
        return this.delegate.getURI();
    }

    @Override
    public List<String> getSubProtocols() {
        return this.delegate.getHeaders().getValuesList(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
    }

    @Override
    public boolean hasSubProtocol(String test) {
        HttpField field = this.delegate.getHeaders().getField(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
        if (field == null) {
            return false;
        }
        return field.contains(test);
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public void addExtensions(ExtensionConfig ... configs) {
    }

    @Override
    public void addExtensions(String ... configs) {
    }

    @Override
    public Object getSession() {
        return null;
    }

    @Override
    public Principal getUserPrincipal() {
        return null;
    }

    @Override
    public void setCookies(List<HttpCookie> cookies) {
    }

    @Override
    public List<ExtensionConfig> getExtensions() {
        List<String> rawExtensions = this.delegate.getHeaders().getValuesList(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (rawExtensions == null || rawExtensions.isEmpty()) {
            return Collections.emptyList();
        }
        return rawExtensions.stream().map(parameterizedName -> ExtensionConfig.parse(parameterizedName)).collect(Collectors.toList());
    }

    @Override
    public void setExtensions(List<ExtensionConfig> configs) {
    }

    @Override
    public void setHeader(String name, List<String> values) {
    }

    @Override
    public void setHeader(String name, String value) {
    }

    @Override
    public void setHeaders(Map<String, List<String>> headers) {
    }

    @Override
    public void setSession(Object session) {
    }

    @Override
    public void setSubProtocols(List<String> protocols) {
    }

    @Override
    public void setSubProtocols(String ... protocols) {
    }
}

