/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.UnavailableException;
import java.io.IOException;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHolder<T>
extends AbstractLifeCycle
implements Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHolder.class);
    private final Source _source;
    private Class<? extends T> _class;
    private String _className;
    private T _instance;
    private ServletHandler _servletHandler;

    protected BaseHolder(Source source) {
        this._source = source;
    }

    public Source getSource() {
        return this._source;
    }

    public void initialize() throws Exception {
        if (!this.isStarted()) {
            throw new IllegalStateException("Not started: " + this);
        }
    }

    @Override
    public void doStart() throws Exception {
        if (this._class == null && (this._className == null || this._className.equals(""))) {
            throw new UnavailableException("No class in holder " + this.toString());
        }
        if (this._class == null) {
            try {
                this._class = Loader.loadClass(this._className);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Holding {} from {}", this._class, (Object)this._class.getClassLoader());
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to load class {}", (Object)this._className, (Object)e);
                throw new UnavailableException("Class loading error for holder " + this.toString());
            }
        }
    }

    @Override
    public void doStop() throws Exception {
        if (this._instance == null) {
            this._class = null;
        }
    }

    @ManagedAttribute(value="Class Name", readonly=true)
    public String getClassName() {
        return this._className;
    }

    public Class<? extends T> getHeldClass() {
        return this._class;
    }

    public ServletHandler getServletHandler() {
        return this._servletHandler;
    }

    public void setServletHandler(ServletHandler servletHandler) {
        this._servletHandler = servletHandler;
    }

    public void setClassName(String className) {
        this._className = className;
        this._class = null;
    }

    public void setHeldClass(Class<? extends T> held) {
        this._class = held;
        if (held != null) {
            this._className = held.getName();
        }
    }

    protected void illegalStateIfContextStarted() {
        ServletContext context;
        if (this._servletHandler != null && (context = this._servletHandler.getServletContext()) instanceof ContextHandler.Context && ((ContextHandler.Context)context).getContextHandler().isStarted()) {
            throw new IllegalStateException("Started");
        }
    }

    protected synchronized void setInstance(T instance) {
        this._instance = instance;
        if (instance == null) {
            this.setHeldClass(null);
        } else {
            this.setHeldClass(instance.getClass());
        }
    }

    protected synchronized T getInstance() {
        return this._instance;
    }

    protected synchronized T createInstance() throws Exception {
        ServletContext ctx = this.getServletContext();
        if (ctx == null) {
            return this.getHeldClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (ServletContextHandler.Context.class.isAssignableFrom(ctx.getClass())) {
            return ((ServletContextHandler.Context)ctx).createInstance(this);
        }
        return null;
    }

    public ServletContext getServletContext() {
        ContextHandler contextHandler;
        ServletContext scontext = null;
        if (this.getServletHandler() != null) {
            scontext = this.getServletHandler().getServletContext();
        }
        if (scontext != null) {
            return scontext;
        }
        ContextHandler.Context ctx = ContextHandler.getCurrentContext();
        if (ctx != null && (contextHandler = ctx.getContextHandler()) != null) {
            return contextHandler.getServletContext();
        }
        return null;
    }

    public synchronized boolean isInstance() {
        return this._instance != null;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObject(out, this);
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }
}

