/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.jaspi;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.security.jaspi.JaspiMessageInfo;
import org.eclipse.jetty.security.jaspi.ServletCallbackHandler;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaspiAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger((String)JaspiAuthenticator.class.getName());
    private final ServerAuthConfig _authConfig;
    private final Map _authProperties;
    private final ServletCallbackHandler _callbackHandler;
    private final Subject _serviceSubject;
    private final boolean _allowLazyAuthentication;
    private final IdentityService _identityService;

    public JaspiAuthenticator(ServerAuthConfig authConfig, Map authProperties, ServletCallbackHandler callbackHandler, Subject serviceSubject, boolean allowLazyAuthentication, IdentityService identityService) {
        if (callbackHandler == null) {
            throw new NullPointerException("No CallbackHandler");
        }
        if (authConfig == null) {
            throw new NullPointerException("No AuthConfig");
        }
        this._authConfig = authConfig;
        this._authProperties = authProperties;
        this._callbackHandler = callbackHandler;
        this._serviceSubject = serviceSubject;
        this._allowLazyAuthentication = allowLazyAuthentication;
        this._identityService = identityService;
    }

    @Override
    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        super.setConfiguration(configuration);
    }

    @Override
    public String getAuthMethod() {
        return "JASPI";
    }

    @Override
    public UserIdentity login(String username, Object password, ServletRequest request) {
        UserIdentity user = this._loginService.login(username, password, request);
        if (user != null) {
            this.renewSession((HttpServletRequest)request, null);
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            if (session != null) {
                SessionAuthentication sessionAuth = new SessionAuthentication(this.getAuthMethod(), user, password);
                session.setAttribute("org.eclipse.jetty.security.UserIdentity", sessionAuth);
            }
        }
        return user;
    }

    @Override
    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        JaspiMessageInfo info = new JaspiMessageInfo(request, response, mandatory);
        request.setAttribute("org.eclipse.jetty.security.jaspi.info", info);
        Authentication a = this.validateRequest(info);
        if (this._allowLazyAuthentication && !info.isAuthMandatory() && a == Authentication.UNAUTHENTICATED) {
            a = new DeferredAuthentication(this);
        }
        return a;
    }

    public Authentication validateRequest(JaspiMessageInfo messageInfo) throws ServerAuthException {
        try {
            String authContextId = this._authConfig.getAuthContextID((MessageInfo)messageInfo);
            ServerAuthContext authContext = this._authConfig.getAuthContext(authContextId, this._serviceSubject, this._authProperties);
            Subject clientSubject = new Subject();
            AuthStatus authStatus = authContext.validateRequest((MessageInfo)messageInfo, clientSubject, this._serviceSubject);
            if (authStatus == AuthStatus.SEND_CONTINUE) {
                return Authentication.SEND_CONTINUE;
            }
            if (authStatus == AuthStatus.SEND_FAILURE) {
                return Authentication.SEND_FAILURE;
            }
            if (authStatus == AuthStatus.SUCCESS) {
                SessionAuthentication cached;
                UserIdentity userIdentity;
                Set<UserIdentity> ids = clientSubject.getPrivateCredentials(UserIdentity.class);
                if (ids.size() > 0) {
                    userIdentity = ids.iterator().next();
                } else {
                    GroupPrincipalCallback groupPrincipalCallback;
                    CallerPrincipalCallback principalCallback = this._callbackHandler.getThreadCallerPrincipalCallback();
                    if (principalCallback == null) {
                        return Authentication.UNAUTHENTICATED;
                    }
                    Principal principal = principalCallback.getPrincipal();
                    if (principal == null) {
                        String principalName = principalCallback.getName();
                        Set<Principal> principals = principalCallback.getSubject().getPrincipals();
                        for (Principal p : principals) {
                            if (!p.getName().equals(principalName)) continue;
                            principal = p;
                            break;
                        }
                        if (principal == null) {
                            return Authentication.UNAUTHENTICATED;
                        }
                    }
                    String[] groups = (groupPrincipalCallback = this._callbackHandler.getThreadGroupPrincipalCallback()) == null ? null : groupPrincipalCallback.getGroups();
                    userIdentity = this._identityService.newUserIdentity(clientSubject, principal, groups);
                }
                HttpSession session = ((HttpServletRequest)messageInfo.getRequestMessage()).getSession(false);
                SessionAuthentication sessionAuthentication = cached = session == null ? null : (SessionAuthentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
                if (cached != null) {
                    return cached;
                }
                return new UserAuthentication(this.getAuthMethod(), userIdentity);
            }
            if (authStatus == AuthStatus.SEND_SUCCESS) {
                return Authentication.SEND_SUCCESS;
            }
            if (authStatus == AuthStatus.FAILURE) {
                HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
                response.sendError(403);
                return Authentication.SEND_FAILURE;
            }
            throw new IllegalStateException("No AuthStatus returned");
        }
        catch (IOException | AuthException e) {
            throw new ServerAuthException(e);
        }
    }

    @Override
    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        JaspiMessageInfo info = (JaspiMessageInfo)req.getAttribute("org.eclipse.jetty.security.jaspi.info");
        if (info == null) {
            throw new NullPointerException("MessageInfo from request missing: " + req);
        }
        return this.secureResponse(info, validatedUser);
    }

    public boolean secureResponse(JaspiMessageInfo messageInfo, Authentication validatedUser) throws ServerAuthException {
        try {
            String authContextId = this._authConfig.getAuthContextID((MessageInfo)messageInfo);
            ServerAuthContext authContext = this._authConfig.getAuthContext(authContextId, this._serviceSubject, this._authProperties);
            AuthStatus status = authContext.secureResponse((MessageInfo)messageInfo, this._serviceSubject);
            return AuthStatus.SEND_SUCCESS.equals(status);
        }
        catch (AuthException e) {
            throw new ServerAuthException(e);
        }
    }
}

