/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.Trie;

public class MsieSslRule
extends Rule {
    private static final int IEv5 = 53;
    private static final int IEv6 = 54;
    private static Trie<Boolean> __IE6_BadOS = new ArrayTernaryTrie<Boolean>();

    public MsieSslRule() {
        __IE6_BadOS.put("NT 5.01", Boolean.TRUE);
        __IE6_BadOS.put("NT 5.0", Boolean.TRUE);
        __IE6_BadOS.put("NT 4.0", Boolean.TRUE);
        __IE6_BadOS.put("98", Boolean.TRUE);
        __IE6_BadOS.put("98; Win 9x 4.90", Boolean.TRUE);
        __IE6_BadOS.put("95", Boolean.TRUE);
        __IE6_BadOS.put("CE", Boolean.TRUE);
        this._handling = false;
        this._terminating = false;
    }

    @Override
    public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        int msie;
        String userAgent;
        if (request.isSecure() && (userAgent = request.getHeader(HttpHeader.USER_AGENT.asString())) != null && (msie = userAgent.indexOf("MSIE")) > 0 && userAgent.length() - msie > 5) {
            int end;
            int windows;
            char ieVersion = userAgent.charAt(msie + 5);
            if (ieVersion <= '5') {
                response.setHeader(HttpHeader.CONNECTION.asString(), HttpHeaderValue.CLOSE.asString());
                return target;
            }
            if (ieVersion == '6' && (windows = userAgent.indexOf("Windows", msie + 5)) > 0 && ((end = userAgent.indexOf(41, windows + 8)) < 0 || __IE6_BadOS.get(userAgent, windows + 8, end - windows - 8) != null)) {
                response.setHeader(HttpHeader.CONNECTION.asString(), HttpHeaderValue.CLOSE.asString());
                return target;
            }
        }
        return null;
    }
}

