/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quickstart;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspPropertyGroupDescriptor;
import jakarta.servlet.descriptor.TaglibDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.plus.annotation.LifeCycleCallback;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.quickstart.AttributeNormalizer;
import org.eclipse.jetty.quickstart.ExtraXmlDescriptorProcessor;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ListenerHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlAppendable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickStartGeneratorConfiguration
extends AbstractConfiguration {
    static final Logger LOG = LoggerFactory.getLogger(QuickStartGeneratorConfiguration.class);
    public static final String ORIGIN = "org.eclipse.jetty.originAttribute";
    public static final String DEFAULT_ORIGIN_ATTRIBUTE_NAME = "origin";
    protected final boolean _abort;
    protected String _originAttribute;
    protected int _count = 0;
    protected Resource _quickStartWebXml;

    public QuickStartGeneratorConfiguration() {
        this(false);
    }

    public QuickStartGeneratorConfiguration(boolean abort) {
        super(false);
        this._abort = abort;
    }

    @Override
    public boolean abort(WebAppContext context) {
        return this._abort;
    }

    public void setOriginAttribute(String name) {
        this._originAttribute = name;
    }

    public String getOriginAttribute() {
        return this._originAttribute;
    }

    public Resource getQuickStartWebXml() {
        return this._quickStartWebXml;
    }

    public void setQuickStartWebXml(Resource quickStartWebXml) {
        this._quickStartWebXml = quickStartWebXml;
    }

    /*
     * WARNING - void declaration
     */
    public void generateQuickStartWebXml(WebAppContext context, OutputStream stream) throws FileNotFoundException, IOException {
        LifeCycleCallbackCollection lifeCycleCallbackCollection;
        ServletContextHandler.JspConfig jspConfig;
        MimeTypes mimeTypes;
        Map<String, String> errorPages;
        Map<String, String> localeEncodings;
        SecurityHandler security;
        String s;
        int n;
        ServletHandler servlets;
        String responseEncoding;
        String requestEncoding;
        if (context == null) {
            throw new IllegalStateException("No webapp for quickstart generation");
        }
        if (stream == null) {
            throw new IllegalStateException("No output for quickstart generation");
        }
        if (this._originAttribute == null) {
            this._originAttribute = DEFAULT_ORIGIN_ATTRIBUTE_NAME;
        }
        context.getMetaData().getOrigins();
        if (context.getBaseResource() == null) {
            throw new IllegalArgumentException("No base resource for " + this);
        }
        MetaData md = context.getMetaData();
        HashMap<String, String> webappAttr = new HashMap<String, String>();
        int major = context.getServletContext().getEffectiveMajorVersion();
        int minor = context.getServletContext().getEffectiveMinorVersion();
        webappAttr.put("xmlns", "http://xmlns.jcp.org/xml/ns/javaee");
        webappAttr.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webappAttr.put("xsi:schemaLocation", "http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/web-app_" + major + "_" + minor + ".xsd");
        webappAttr.put("metadata-complete", "true");
        webappAttr.put("version", major + "." + minor);
        XmlAppendable out = new XmlAppendable(stream, "UTF-8");
        out.openTag("web-app", webappAttr);
        if (context.getDisplayName() != null) {
            out.tag("display-name", context.getDisplayName());
        }
        AttributeNormalizer normalizer = new AttributeNormalizer(context.getBaseResource());
        this.addContextParamFromAttribute(context, out, "jakarta.servlet.context.orderedLibs");
        this.addContextParamFromAttribute(context, out, "org.eclipse.jetty.containerInitializers");
        this.addContextParamFromAttribute(context, out, "org.eclipse.jetty.tlds", normalizer);
        this.addContextParamFromAttribute(context, out, "org.eclipse.jetty.resources", normalizer);
        String defaultContextPath = (String)context.getAttribute("default-context-path");
        if (defaultContextPath != null) {
            out.tag("default-context-path", defaultContextPath);
        }
        if (!StringUtil.isBlank(requestEncoding = (String)context.getAttribute("request-character-encoding"))) {
            out.tag("request-character-encoding", requestEncoding);
        }
        if (!StringUtil.isBlank(responseEncoding = (String)context.getAttribute("response-character-encoding"))) {
            out.tag("response-character-encoding", responseEncoding);
        }
        if (StringUtil.isNotBlank(this._originAttribute)) {
            out.openTag("context-param").tag("param-name", ORIGIN).tag("param-value", this._originAttribute).closeTag();
        }
        for (String p : context.getInitParams().keySet()) {
            out.openTag("context-param", this.origin(md, "context-param." + p)).tag("param-name", p).tag("param-value", context.getInitParameter(p)).closeTag();
        }
        if (context.getServletHandler().getListeners() != null) {
            for (ListenerHolder e : context.getServletHandler().getListeners()) {
                out.openTag("listener", this.origin(md, e.getClassName() + ".listener")).tag("listener-class", e.getClassName()).closeTag();
            }
        }
        if ((servlets = context.getServletHandler()).getFilters() != null) {
            for (FilterHolder filterHolder : servlets.getFilters()) {
                this.outholder(out, md, filterHolder);
            }
        }
        if (servlets.getFilterMappings() != null) {
            for (FilterMapping filterMapping : servlets.getFilterMappings()) {
                int n2;
                out.openTag("filter-mapping");
                out.tag("filter-name", filterMapping.getFilterName());
                if (filterMapping.getPathSpecs() != null) {
                    String[] stringArray = filterMapping.getPathSpecs();
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        s = stringArray[n];
                        out.tag("url-pattern", s);
                    }
                }
                if (filterMapping.getServletNames() != null) {
                    String[] stringArray = filterMapping.getServletNames();
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        String n3 = stringArray[n];
                        out.tag("servlet-name", n3);
                    }
                }
                if (!filterMapping.isDefaultDispatches()) {
                    if (filterMapping.appliesTo(DispatcherType.REQUEST)) {
                        out.tag("dispatcher", "REQUEST");
                    }
                    if (filterMapping.appliesTo(DispatcherType.ASYNC)) {
                        out.tag("dispatcher", "ASYNC");
                    }
                    if (filterMapping.appliesTo(DispatcherType.ERROR)) {
                        out.tag("dispatcher", "ERROR");
                    }
                    if (filterMapping.appliesTo(DispatcherType.FORWARD)) {
                        out.tag("dispatcher", "FORWARD");
                    }
                    if (filterMapping.appliesTo(DispatcherType.INCLUDE)) {
                        out.tag("dispatcher", "INCLUDE");
                    }
                }
                out.closeTag();
            }
        }
        if (servlets.getServlets() != null) {
            for (ServletHolder servletHolder : servlets.getServlets()) {
                this.outholder(out, md, servletHolder);
            }
        }
        if (servlets.getServletMappings() != null) {
            for (ServletMapping servletMapping : servlets.getServletMappings()) {
                out.openTag("servlet-mapping", this.origin(md, servletMapping.getServletName() + ".servlet.mappings"));
                out.tag("servlet-name", servletMapping.getServletName());
                if (servletMapping.getPathSpecs() != null) {
                    String[] stringArray = servletMapping.getPathSpecs();
                    int n4 = stringArray.length;
                    for (n = 0; n < n4; ++n) {
                        s = stringArray[n];
                        out.tag("url-pattern", s);
                    }
                }
                out.closeTag();
            }
        }
        if ((security = context.getSecurityHandler()) != null && (security.getRealmName() != null || security.getAuthMethod() != null)) {
            out.openTag("login-config");
            if (security.getAuthMethod() != null) {
                out.tag("auth-method", this.origin(md, "auth-method"), security.getAuthMethod());
            }
            if (security.getRealmName() != null) {
                out.tag("realm-name", this.origin(md, "realm-name"), security.getRealmName());
            }
            if ("FORM".equalsIgnoreCase(security.getAuthMethod())) {
                out.openTag("form-login-config");
                out.tag("form-login-page", this.origin(md, "form-login-page"), security.getInitParameter("org.eclipse.jetty.security.form_login_page"));
                out.tag("form-error-page", this.origin(md, "form-error-page"), security.getInitParameter("org.eclipse.jetty.security.form_error_page"));
                out.closeTag();
            }
            out.closeTag();
        }
        if (security instanceof ConstraintAware) {
            ConstraintAware ca = (ConstraintAware)((Object)security);
            for (String string : ca.getRoles()) {
                out.openTag("security-role").tag("role-name", string).closeTag();
            }
            for (ConstraintMapping constraintMapping : ca.getConstraintMappings()) {
                out.openTag("security-constraint");
                out.openTag("web-resource-collection");
                if (constraintMapping.getConstraint().getName() != null) {
                    out.tag("web-resource-name", constraintMapping.getConstraint().getName());
                }
                if (constraintMapping.getPathSpec() != null) {
                    out.tag("url-pattern", this.origin(md, "constraint.url." + constraintMapping.getPathSpec()), constraintMapping.getPathSpec());
                }
                if (constraintMapping.getMethod() != null) {
                    out.tag("http-method", constraintMapping.getMethod());
                }
                if (constraintMapping.getMethodOmissions() != null) {
                    for (String o : constraintMapping.getMethodOmissions()) {
                        out.tag("http-method-omission", o);
                    }
                }
                out.closeTag();
                if (constraintMapping.getConstraint().getAuthenticate()) {
                    String[] stringArray = constraintMapping.getConstraint().getRoles();
                    if (stringArray != null && stringArray.length > 0) {
                        out.openTag("auth-constraint");
                        if (constraintMapping.getConstraint().getRoles() != null) {
                            for (String r : constraintMapping.getConstraint().getRoles()) {
                                out.tag("role-name", r);
                            }
                        }
                        out.closeTag();
                    } else {
                        out.tag("auth-constraint");
                    }
                }
                switch (constraintMapping.getConstraint().getDataConstraint()) {
                    case 0: {
                        out.openTag("user-data-constraint").tag("transport-guarantee", "NONE").closeTag();
                        break;
                    }
                    case 1: {
                        out.openTag("user-data-constraint").tag("transport-guarantee", "INTEGRAL").closeTag();
                        break;
                    }
                    case 2: {
                        out.openTag("user-data-constraint").tag("transport-guarantee", "CONFIDENTIAL").closeTag();
                        break;
                    }
                }
                out.closeTag();
            }
        }
        if (context.getWelcomeFiles() != null) {
            void var16_46;
            out.openTag("welcome-file-list");
            String[] ca = context.getWelcomeFiles();
            int e = ca.length;
            boolean bl = false;
            while (var16_46 < e) {
                String string = ca[var16_46];
                out.tag("welcome-file", string);
                ++var16_46;
            }
            out.closeTag();
        }
        if ((localeEncodings = context.getLocaleEncodings()) != null && !localeEncodings.isEmpty()) {
            out.openTag("locale-encoding-mapping-list");
            for (Map.Entry<String, String> entry : localeEncodings.entrySet()) {
                out.openTag("locale-encoding-mapping", this.origin(md, "locale-encoding." + entry.getKey()));
                out.tag("locale", entry.getKey());
                out.tag("encoding", entry.getValue());
                out.closeTag();
            }
            out.closeTag();
        }
        if (context.getSessionHandler() != null) {
            Set<SessionTrackingMode> set;
            out.openTag("session-config");
            int maxInactiveSec = context.getSessionHandler().getMaxInactiveInterval();
            out.tag("session-timeout", maxInactiveSec == 0 ? "0" : Integer.toString(maxInactiveSec / 60));
            SessionCookieConfig sessionCookieConfig = context.getSessionHandler().getSessionCookieConfig();
            if (sessionCookieConfig != null) {
                out.openTag("cookie-config");
                if (sessionCookieConfig.getName() != null) {
                    out.tag("name", this.origin(md, "cookie-config.name"), sessionCookieConfig.getName());
                }
                if (sessionCookieConfig.getDomain() != null) {
                    out.tag("domain", this.origin(md, "cookie-config.domain"), sessionCookieConfig.getDomain());
                }
                if (sessionCookieConfig.getPath() != null) {
                    out.tag("path", this.origin(md, "cookie-config.path"), sessionCookieConfig.getPath());
                }
                if (sessionCookieConfig.getComment() != null) {
                    out.tag("comment", this.origin(md, "cookie-config.comment"), sessionCookieConfig.getComment());
                }
                out.tag("http-only", this.origin(md, "cookie-config.http-only"), Boolean.toString(sessionCookieConfig.isHttpOnly()));
                out.tag("secure", this.origin(md, "cookie-config.secure"), Boolean.toString(sessionCookieConfig.isSecure()));
                out.tag("max-age", this.origin(md, "cookie-config.max-age"), Integer.toString(sessionCookieConfig.getMaxAge()));
                out.closeTag();
            }
            if ((set = context.getSessionHandler().getEffectiveSessionTrackingModes()) != null) {
                for (SessionTrackingMode mode : set) {
                    out.tag("tracking-mode", mode.toString());
                }
            }
            out.closeTag();
        }
        if ((errorPages = ((ErrorPageErrorHandler)context.getErrorHandler()).getErrorPages()) != null) {
            for (Map.Entry<String, String> entry : errorPages.entrySet()) {
                out.openTag("error-page", this.origin(md, "error." + entry.getKey()));
                if (!"org.eclipse.jetty.server.error_page.global".equals(entry.getKey())) {
                    if (entry.getKey().matches("\\d{3}")) {
                        out.tag("error-code", entry.getKey());
                    } else {
                        out.tag("exception-type", entry.getKey());
                    }
                }
                out.tag("location", entry.getValue());
                out.closeTag();
            }
        }
        if ((mimeTypes = context.getMimeTypes()) != null) {
            for (Map.Entry<String, String> entry : mimeTypes.getMimeMap().entrySet()) {
                out.openTag("mime-mapping");
                out.tag("extension", this.origin(md, "extension." + entry.getKey()), entry.getKey());
                out.tag("mime-type", entry.getValue());
                out.closeTag();
            }
        }
        if ((jspConfig = (ServletContextHandler.JspConfig)context.getServletContext().getJspConfigDescriptor()) != null) {
            Collection<JspPropertyGroupDescriptor> jspPropertyGroups;
            out.openTag("jsp-config");
            Collection<TaglibDescriptor> collection = jspConfig.getTaglibs();
            if (collection != null && !collection.isEmpty()) {
                for (TaglibDescriptor tld : collection) {
                    out.openTag("taglib");
                    out.tag("taglib-uri", tld.getTaglibURI());
                    out.tag("taglib-location", tld.getTaglibLocation());
                    out.closeTag();
                }
            }
            if ((jspPropertyGroups = jspConfig.getJspPropertyGroups()) != null && !jspPropertyGroups.isEmpty()) {
                for (JspPropertyGroupDescriptor jspPropertyGroup : jspPropertyGroups) {
                    out.openTag("jsp-property-group");
                    Collection<String> strings = jspPropertyGroup.getUrlPatterns();
                    if (strings != null && !strings.isEmpty()) {
                        for (String urlPattern : strings) {
                            out.tag("url-pattern", urlPattern);
                        }
                    }
                    if (jspPropertyGroup.getElIgnored() != null) {
                        out.tag("el-ignored", jspPropertyGroup.getElIgnored());
                    }
                    if (jspPropertyGroup.getPageEncoding() != null) {
                        out.tag("page-encoding", jspPropertyGroup.getPageEncoding());
                    }
                    if (jspPropertyGroup.getScriptingInvalid() != null) {
                        out.tag("scripting-invalid", jspPropertyGroup.getScriptingInvalid());
                    }
                    if (jspPropertyGroup.getIsXml() != null) {
                        out.tag("is-xml", jspPropertyGroup.getIsXml());
                    }
                    if (jspPropertyGroup.getDeferredSyntaxAllowedAsLiteral() != null) {
                        out.tag("deferred-syntax-allowed-as-literal", jspPropertyGroup.getDeferredSyntaxAllowedAsLiteral());
                    }
                    if (jspPropertyGroup.getTrimDirectiveWhitespaces() != null) {
                        out.tag("trim-directive-whitespaces", jspPropertyGroup.getTrimDirectiveWhitespaces());
                    }
                    if (jspPropertyGroup.getDefaultContentType() != null) {
                        out.tag("default-content-type", jspPropertyGroup.getDefaultContentType());
                    }
                    if (jspPropertyGroup.getBuffer() != null) {
                        out.tag("buffer", jspPropertyGroup.getBuffer());
                    }
                    if (jspPropertyGroup.getErrorOnUndeclaredNamespace() != null) {
                        out.tag("error-on-undeclared-namespace", jspPropertyGroup.getErrorOnUndeclaredNamespace());
                    }
                    if ((strings = jspPropertyGroup.getIncludePreludes()) != null && !strings.isEmpty()) {
                        for (String prelude : strings) {
                            out.tag("include-prelude", prelude);
                        }
                    }
                    if ((strings = jspPropertyGroup.getIncludeCodas()) != null && !strings.isEmpty()) {
                        for (String coda : strings) {
                            out.tag("include-coda", coda);
                        }
                    }
                    out.closeTag();
                }
            }
            out.closeTag();
        }
        if ((lifeCycleCallbackCollection = (LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")) != null) {
            Collection<LifeCycleCallback> tmp = lifeCycleCallbackCollection.getPostConstructCallbacks();
            for (LifeCycleCallback c : tmp) {
                out.openTag("post-construct");
                out.tag("lifecycle-callback-class", c.getTargetClassName());
                out.tag("lifecycle-callback-method", c.getMethodName());
                out.closeTag();
            }
            tmp = lifeCycleCallbackCollection.getPreDestroyCallbacks();
            for (LifeCycleCallback c : tmp) {
                out.openTag("pre-destroy");
                out.tag("lifecycle-callback-class", c.getTargetClassName());
                out.tag("lifecycle-callback-method", c.getMethodName());
                out.closeTag();
            }
        }
        ExtraXmlDescriptorProcessor extraXmlProcessor = (ExtraXmlDescriptorProcessor)context.getAttribute(ExtraXmlDescriptorProcessor.class.getName());
        out.literal(extraXmlProcessor.getXML());
        out.closeTag();
    }

    private void addContextParamFromAttribute(WebAppContext context, XmlAppendable out, String attribute) throws IOException {
        Object o = context.getAttribute(attribute);
        if (o == null) {
            return;
        }
        List<Object> c = o instanceof Collection ? (List<Object>)o : Collections.singletonList(o);
        StringBuilder v = new StringBuilder();
        for (Object e : c) {
            if (e == null) continue;
            if (v.length() > 0) {
                v.append(",\n    ");
            } else {
                v.append("\n    ");
            }
            QuotedStringTokenizer.quote(v, e.toString());
        }
        out.openTag("context-param").tag("param-name", attribute).tagCDATA("param-value", v.toString()).closeTag();
    }

    private void addContextParamFromAttribute(WebAppContext context, XmlAppendable out, String attribute, AttributeNormalizer normalizer) throws IOException {
        Object o = context.getAttribute(attribute);
        if (o == null) {
            return;
        }
        List<Object> c = o instanceof Collection ? (List<Object>)o : Collections.singletonList(o);
        StringBuilder v = new StringBuilder();
        for (Object e : c) {
            if (e == null) continue;
            if (v.length() > 0) {
                v.append(",\n    ");
            } else {
                v.append("\n    ");
            }
            QuotedStringTokenizer.quote(v, normalizer.normalize(e));
        }
        out.openTag("context-param").tag("param-name", attribute).tagCDATA("param-value", v.toString()).closeTag();
    }

    private void outholder(XmlAppendable out, MetaData md, FilterHolder holder) throws IOException {
        if (LOG.isDebugEnabled()) {
            out.openTag("filter", Collections.singletonMap("source", holder.getSource().toString()));
        } else {
            out.openTag("filter");
        }
        String n = holder.getName();
        out.tag("filter-name", n);
        String ot = n + ".filter.";
        if (holder instanceof FilterHolder) {
            out.tag("filter-class", this.origin(md, ot + "filter-class"), holder.getClassName());
            out.tag("async-supported", this.origin(md, ot + "async-supported"), holder.isAsyncSupported() ? "true" : "false");
        }
        for (String p : holder.getInitParameters().keySet()) {
            out.openTag("init-param", this.origin(md, ot + "init-param." + p)).tag("param-name", p).tag("param-value", holder.getInitParameter(p)).closeTag();
        }
        out.closeTag();
    }

    private void outholder(XmlAppendable out, MetaData md, ServletHolder holder) throws IOException {
        MultipartConfigElement multipartConfigElement;
        Map<String, String> roles;
        if (LOG.isDebugEnabled()) {
            out.openTag("servlet", Collections.singletonMap("source", holder.getSource().toString()));
        } else {
            out.openTag("servlet");
        }
        String n = holder.getName();
        out.tag("servlet-name", n);
        String ot = n + ".servlet.";
        ServletHolder s = holder;
        if (s.getForcedPath() != null && s.getClassName() == null) {
            out.tag("jsp-file", s.getForcedPath());
        } else {
            out.tag("servlet-class", this.origin(md, ot + "servlet-class"), s.getClassName());
        }
        for (String string : holder.getInitParameters().keySet()) {
            if ("jsp".equalsIgnoreCase(n) && "scratchdir".equalsIgnoreCase(string)) continue;
            out.openTag("init-param", this.origin(md, ot + "init-param." + string)).tag("param-name", string).tag("param-value", holder.getInitParameter(string)).closeTag();
        }
        if (s.getInitOrder() >= 0) {
            out.tag("load-on-startup", Integer.toString(s.getInitOrder()));
        }
        if (!s.isEnabled()) {
            out.tag("enabled", this.origin(md, ot + "enabled"), "false");
        }
        out.tag("async-supported", this.origin(md, ot + "async-supported"), holder.isAsyncSupported() ? "true" : "false");
        if (s.getRunAsRole() != null) {
            out.openTag("run-as", this.origin(md, ot + "run-as")).tag("role-name", s.getRunAsRole()).closeTag();
        }
        if ((roles = s.getRoleRefMap()) != null) {
            for (Map.Entry<String, String> entry : roles.entrySet()) {
                out.openTag("security-role-ref", this.origin(md, ot + "role-name." + entry.getKey())).tag("role-name", entry.getKey()).tag("role-link", entry.getValue()).closeTag();
            }
        }
        if ((multipartConfigElement = ((ServletHolder.Registration)s.getRegistration()).getMultipartConfig()) != null) {
            out.openTag("multipart-config", this.origin(md, s.getName() + ".servlet.multipart-config"));
            if (multipartConfigElement.getLocation() != null) {
                out.tag("location", multipartConfigElement.getLocation());
            }
            out.tag("max-file-size", Long.toString(multipartConfigElement.getMaxFileSize()));
            out.tag("max-request-size", Long.toString(multipartConfigElement.getMaxRequestSize()));
            out.tag("file-size-threshold", Long.toString(multipartConfigElement.getFileSizeThreshold()));
            out.closeTag();
        }
        out.closeTag();
    }

    public Map<String, String> origin(MetaData md, String name) {
        if (StringUtil.isBlank(this._originAttribute)) {
            return Collections.emptyMap();
        }
        if (name == null) {
            return Collections.emptyMap();
        }
        MetaData.OriginInfo origin = md.getOriginInfo(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug("origin of " + name + " is " + origin);
        }
        if (origin == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this._originAttribute, origin.toString() + ":" + this._count++);
    }

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        ExtraXmlDescriptorProcessor extraXmlProcessor = new ExtraXmlDescriptorProcessor();
        context.getMetaData().addDescriptorProcessor(extraXmlProcessor);
        context.setAttribute(ExtraXmlDescriptorProcessor.class.getName(), extraXmlProcessor);
        super.preConfigure(context);
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        MetaData metadata = context.getMetaData();
        metadata.resolve(context);
        try (FileOutputStream fos = new FileOutputStream(this._quickStartWebXml.getFile(), false);){
            this.generateQuickStartWebXml(context, fos);
            LOG.info("Generated {}", (Object)this._quickStartWebXml);
            if (context.getAttribute("org.eclipse.jetty.webapp.tmpResourceBase") != null && !context.isPersistTempDirectory()) {
                LOG.warn("Generated to non persistent location: " + this._quickStartWebXml);
            }
        }
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        super.deconfigure(context);
    }
}

