/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http2.HTTP2Channel;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.server.HttpTransportOverHTTP2;
import org.eclipse.jetty.http2.server.ServerHTTP2StreamEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelOverHTTP2
extends HttpChannel
implements Closeable,
WriteFlusher.Listener,
HTTP2Channel.Server {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannelOverHTTP2.class);
    private static final HttpField SERVER_VERSION = new PreEncodedHttpField(HttpHeader.SERVER, HttpConfiguration.SERVER_VERSION);
    private static final HttpField POWERED_BY = new PreEncodedHttpField(HttpHeader.X_POWERED_BY, HttpConfiguration.SERVER_VERSION);
    private boolean _expect100Continue;
    private boolean _delayedUntilContent;
    private boolean _useOutputDirectByteBuffers;

    public HttpChannelOverHTTP2(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransportOverHTTP2 transport) {
        super(connector, configuration, endPoint, transport);
    }

    protected IStream getStream() {
        return this.getHttpTransport().getStream();
    }

    @Override
    public boolean isUseOutputDirectByteBuffers() {
        return this._useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this._useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    @Override
    public boolean isExpecting100Continue() {
        return this._expect100Continue;
    }

    @Override
    public void setIdleTimeout(long timeoutMs) {
        this.getStream().setIdleTimeout(timeoutMs);
    }

    @Override
    public long getIdleTimeout() {
        return this.getStream().getIdleTimeout();
    }

    @Override
    public void onFlushed(long bytes) throws IOException {
        this.getResponse().getHttpOutput().onFlushed(bytes);
    }

    public Runnable onRequest(HeadersFrame frame) {
        try {
            MetaData.Request request = (MetaData.Request)frame.getMetaData();
            HttpFields fields = request.getFields();
            this._expect100Continue = fields.contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
            HttpFields.Mutable response = this.getResponse().getHttpFields();
            if (this.getHttpConfiguration().getSendServerVersion()) {
                response.add(SERVER_VERSION);
            }
            if (this.getHttpConfiguration().getSendXPoweredBy()) {
                response.add(POWERED_BY);
            }
            this.onRequest(request);
            boolean endStream = frame.isEndStream();
            if (endStream) {
                this.onContentComplete();
                this.onRequestComplete();
            }
            boolean connect = request instanceof MetaData.ConnectRequest;
            boolean bl = this._delayedUntilContent = this.getHttpConfiguration().isDelayDispatchUntilContent() && !endStream && !this._expect100Continue && !connect;
            if (!connect || request.getProtocol() == null) {
                this.getStream().demand(1L);
            }
            if (LOG.isDebugEnabled()) {
                IStream stream = this.getStream();
                LOG.debug("HTTP2 Request #{}/{}, delayed={}:{}{} {} {}{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), this._delayedUntilContent, System.lineSeparator(), request.getMethod(), request.getURI(), request.getHttpVersion(), System.lineSeparator(), fields});
            }
            return this._delayedUntilContent ? null : this;
        }
        catch (BadMessageException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onRequest", (Throwable)x);
            }
            this.onBadMessage(x);
            return null;
        }
        catch (Throwable x) {
            this.onBadMessage(new BadMessageException(500, null, x));
            return null;
        }
    }

    public Runnable onPushRequest(MetaData.Request request) {
        try {
            this.onRequest(request);
            this.getRequest().setAttribute("org.eclipse.jetty.pushed", Boolean.TRUE);
            this.onContentComplete();
            this.onRequestComplete();
            if (LOG.isDebugEnabled()) {
                IStream stream = this.getStream();
                LOG.debug("HTTP2 PUSH Request #{}/{}:{}{} {} {}{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), System.lineSeparator(), request.getMethod(), request.getURI(), request.getHttpVersion(), System.lineSeparator(), request.getFields()});
            }
            return this;
        }
        catch (BadMessageException x) {
            this.onBadMessage(x);
            return null;
        }
        catch (Throwable x) {
            this.onBadMessage(new BadMessageException(500, null, x));
            return null;
        }
    }

    @Override
    public HttpTransportOverHTTP2 getHttpTransport() {
        return (HttpTransportOverHTTP2)super.getHttpTransport();
    }

    @Override
    public void recycle() {
        this._expect100Continue = false;
        this._delayedUntilContent = false;
        super.recycle();
        this.getHttpTransport().recycle();
    }

    @Override
    protected void commit(MetaData.Response info) {
        super.commit(info);
        if (LOG.isDebugEnabled()) {
            IStream stream = this.getStream();
            LOG.debug("HTTP2 Commit Response #{}/{}:{}{} {} {}{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), System.lineSeparator(), info.getHttpVersion(), info.getStatus(), info.getReason(), System.lineSeparator(), info.getFields()});
        }
    }

    @Override
    public Runnable onData(DataFrame frame, Callback callback) {
        return this.onRequestContent(frame, callback);
    }

    public Runnable onRequestContent(DataFrame frame, final Callback callback) {
        IStream stream = this.getStream();
        if (stream.isReset()) {
            this.consumeInput();
            callback.succeeded();
            return null;
        }
        ByteBuffer buffer = frame.getData();
        int length = buffer.remaining();
        boolean handle = this.onContent(new HttpInput.Content(buffer){

            @Override
            public void succeeded() {
                callback.succeeded();
            }

            @Override
            public void failed(Throwable x) {
                callback.failed(x);
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return callback.getInvocationType();
            }
        });
        boolean endStream = frame.isEndStream();
        if (endStream) {
            boolean handleContent = this.onContentComplete();
            boolean handleRequest = this.onRequestComplete();
            handle |= handleContent | handleRequest;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Request #{}/{}: {} bytes of {} content, handle: {}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), length, endStream ? "last" : "some", handle});
        }
        boolean wasDelayed = this._delayedUntilContent;
        this._delayedUntilContent = false;
        return handle || wasDelayed ? this : null;
    }

    @Override
    public Runnable onTrailer(HeadersFrame frame) {
        HttpFields trailers = frame.getMetaData().getFields();
        if (trailers.size() > 0) {
            this.onTrailers(trailers);
        }
        if (LOG.isDebugEnabled()) {
            IStream stream = this.getStream();
            LOG.debug("HTTP2 Request #{}/{}, trailers:{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), System.lineSeparator(), trailers});
        }
        boolean handle = this.onRequestComplete();
        boolean wasDelayed = this._delayedUntilContent;
        this._delayedUntilContent = false;
        return handle || wasDelayed ? this : null;
    }

    @Override
    public boolean isIdle() {
        return this.getState().isIdle();
    }

    @Override
    public boolean onTimeout(Throwable failure, Consumer<Runnable> consumer) {
        boolean delayed = this._delayedUntilContent;
        this._delayedUntilContent = false;
        boolean result = this.isIdle();
        if (result) {
            this.consumeInput();
        }
        this.getHttpTransport().onStreamTimeout(failure);
        if (this.getRequest().getHttpInput().onIdleTimeout(failure) || delayed) {
            consumer.accept(this::handleWithContext);
            result = false;
        }
        return result;
    }

    @Override
    public Runnable onFailure(Throwable failure, Callback callback) {
        this.getHttpTransport().onStreamFailure(failure);
        boolean handle = this.getRequest().getHttpInput().failed(failure);
        this.consumeInput();
        return new FailureTask(failure, callback, handle);
    }

    protected void consumeInput() {
        this.getRequest().getHttpInput().consumeAll();
    }

    private void handleWithContext() {
        ContextHandler context = this.getState().getContextHandler();
        if (context != null) {
            context.handle(this.getRequest(), this);
        } else {
            this.handle();
        }
    }

    @Override
    public void continue100(int available) throws IOException {
        if (this.isExpecting100Continue()) {
            this._expect100Continue = false;
            if (available == 0) {
                if (this.getResponse().isCommitted()) {
                    throw new IOException("Committed before 100 Continues");
                }
                boolean committed = this.sendResponse(HttpGenerator.CONTINUE_100_INFO, null, false);
                if (!committed) {
                    throw new IOException("Concurrent commit while trying to send 100-Continue");
                }
            }
        }
    }

    @Override
    public boolean isTunnellingSupported() {
        return true;
    }

    @Override
    public EndPoint getTunnellingEndPoint() {
        return new ServerHTTP2StreamEndPoint(this.getStream());
    }

    @Override
    public void close() {
        this.abort(new IOException("Unexpected close"));
    }

    @Override
    public String toString() {
        IStream stream = this.getStream();
        long streamId = stream == null ? -1L : (long)stream.getId();
        return String.format("%s#%d", super.toString(), streamId);
    }

    private class FailureTask
    implements Runnable {
        private final Throwable failure;
        private final Callback callback;
        private final boolean handle;

        public FailureTask(Throwable failure, Callback callback, boolean handle) {
            this.failure = failure;
            this.callback = callback;
            this.handle = handle;
        }

        @Override
        public void run() {
            try {
                if (this.handle) {
                    HttpChannelOverHTTP2.this.handleWithContext();
                } else if (HttpChannelOverHTTP2.this.getHttpConfiguration().isNotifyRemoteAsyncErrors()) {
                    HttpChannelOverHTTP2.this.getState().asyncError(this.failure);
                }
                this.callback.succeeded();
            }
            catch (Throwable x) {
                this.callback.failed(x);
            }
        }

        public String toString() {
            return String.format("%s@%x[%s]", this.getClass().getName(), this.hashCode(), this.failure);
        }
    }
}

