/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.bindings;

import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppLifeCycle;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.deploy.providers.WebAppProvider;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalWebappConfigBinding
implements AppLifeCycle.Binding {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalWebappConfigBinding.class);
    private String _jettyXml;

    public String getJettyXml() {
        return this._jettyXml;
    }

    public void setJettyXml(String jettyXml) {
        this._jettyXml = jettyXml;
    }

    @Override
    public String[] getBindingTargets() {
        return new String[]{"deploying"};
    }

    @Override
    public void processBinding(Node node, App app) throws Exception {
        ContextHandler handler = app.getContextHandler();
        if (handler == null) {
            throw new NullPointerException("No Handler created for App: " + app);
        }
        if (handler instanceof WebAppContext) {
            Resource globalContextSettings;
            WebAppContext context = (WebAppContext)handler;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Binding: Configuring webapp context with global settings from: " + this._jettyXml);
            }
            if (this._jettyXml == null) {
                LOG.warn("Binding: global context binding is enabled but no jetty-web.xml file has been registered");
            }
            if ((globalContextSettings = Resource.newResource(this._jettyXml)).exists()) {
                WebAppProvider webAppProvider;
                XmlConfiguration jettyXmlConfig = new XmlConfiguration(globalContextSettings);
                Resource resource = Resource.newResource(app.getOriginId());
                app.getDeploymentManager().scope(jettyXmlConfig, resource);
                AppProvider appProvider = app.getAppProvider();
                if (appProvider instanceof WebAppProvider && (webAppProvider = (WebAppProvider)appProvider).getConfigurationManager() != null) {
                    jettyXmlConfig.getProperties().putAll(webAppProvider.getConfigurationManager().getProperties());
                }
                WebAppClassLoader.runWithServerClassAccess(() -> {
                    jettyXmlConfig.configure(context);
                    return null;
                });
            } else {
                LOG.info("Binding: Unable to locate global webapp context settings: " + this._jettyXml);
            }
        }
    }
}

