/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.proxy;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyProtocolClientConnectionFactory
implements ClientConnectionFactory {
    private final ClientConnectionFactory connectionFactory;
    private final Supplier<Origin.Address> proxiedAddressSupplier;

    public ProxyProtocolClientConnectionFactory(ClientConnectionFactory connectionFactory, Supplier<Origin.Address> proxiedAddressSupplier) {
        this.connectionFactory = connectionFactory;
        this.proxiedAddressSupplier = proxiedAddressSupplier;
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
        HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
        Executor executor = destination.getHttpClient().getExecutor();
        ProxyProtocolConnection connection = new ProxyProtocolConnection(endPoint, executor, context);
        return this.customize(connection, context);
    }

    private class ProxyProtocolConnection
    extends AbstractConnection
    implements Callback {
        private final Logger log;
        private final Map<String, Object> context;

        public ProxyProtocolConnection(EndPoint endPoint, Executor executor, Map<String, Object> context) {
            super(endPoint, executor);
            this.log = LoggerFactory.getLogger(ProxyProtocolConnection.class);
            this.context = context;
        }

        @Override
        public void onOpen() {
            super.onOpen();
            this.writePROXYLine();
        }

        protected void writePROXYLine() {
            Origin.Address proxiedAddress = ProxyProtocolClientConnectionFactory.this.proxiedAddressSupplier.get();
            if (proxiedAddress == null) {
                this.failed(new IllegalArgumentException("Missing proxied socket address"));
                return;
            }
            String proxiedIP = proxiedAddress.getHost();
            int proxiedPort = proxiedAddress.getPort();
            InetSocketAddress serverSocketAddress = this.getEndPoint().getRemoteAddress();
            InetAddress serverAddress = serverSocketAddress.getAddress();
            String serverIP = serverAddress.getHostAddress();
            int serverPort = serverSocketAddress.getPort();
            boolean ipv6 = serverAddress instanceof Inet6Address;
            String line = String.format("PROXY %s %s %s %d %d\r\n", ipv6 ? "TCP6" : "TCP4", proxiedIP, serverIP, proxiedPort, serverPort);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Writing PROXY line: {}", (Object)line.trim());
            }
            ByteBuffer buffer = ByteBuffer.wrap(line.getBytes(StandardCharsets.US_ASCII));
            this.getEndPoint().write(this, buffer);
        }

        @Override
        public void succeeded() {
            try {
                EndPoint endPoint = this.getEndPoint();
                Connection connection = ProxyProtocolClientConnectionFactory.this.connectionFactory.newConnection(endPoint, this.context);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Written PROXY line, upgrading to {}", (Object)connection);
                }
                endPoint.upgrade(connection);
            }
            catch (Throwable x) {
                this.failed(x);
            }
        }

        @Override
        public void failed(Throwable x) {
            this.close();
            Promise promise = (Promise)this.context.get("org.eclipse.jetty.client.connection.promise");
            promise.failed(x);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }

        @Override
        public void onFillable() {
        }
    }
}

