/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLContext;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.SelectConnector;
import org.eclipse.jetty.client.SocketConnector;
import org.eclipse.jetty.client.security.Authentication;
import org.eclipse.jetty.client.security.RealmResolver;
import org.eclipse.jetty.http.HttpBuffers;
import org.eclipse.jetty.http.HttpBuffersImpl;
import org.eclipse.jetty.http.HttpSchemes;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.Timeout;

public class HttpClient
extends AggregateLifeCycle
implements HttpBuffers,
Attributes,
Dumpable {
    public static final int CONNECTOR_SOCKET = 0;
    public static final int CONNECTOR_SELECT_CHANNEL = 2;
    private int _connectorType = 2;
    private boolean _useDirectBuffers = true;
    private boolean _connectBlocking = true;
    private int _maxConnectionsPerAddress = Integer.MAX_VALUE;
    private int _maxQueueSizePerAddress = Integer.MAX_VALUE;
    private ConcurrentMap<Address, HttpDestination> _destinations = new ConcurrentHashMap<Address, HttpDestination>();
    ThreadPool _threadPool;
    Connector _connector;
    private long _idleTimeout = 20000L;
    private long _timeout = 320000L;
    private int _connectTimeout = 75000;
    private Timeout _timeoutQ = new Timeout();
    private Timeout _idleTimeoutQ = new Timeout();
    private Address _proxy;
    private Authentication _proxyAuthentication;
    private Set<String> _noProxy;
    private int _maxRetries = 3;
    private int _maxRedirects = 20;
    private LinkedList<String> _registeredListeners;
    private final SslContextFactory _sslContextFactory;
    private RealmResolver _realmResolver;
    private AttributesMap _attributes = new AttributesMap();
    private final HttpBuffersImpl _buffers = new HttpBuffersImpl();

    private void setBufferTypes() {
        if (this._connectorType == 0) {
            this._buffers.setRequestBufferType(Buffers.Type.BYTE_ARRAY);
            this._buffers.setRequestHeaderType(Buffers.Type.BYTE_ARRAY);
            this._buffers.setResponseBufferType(Buffers.Type.BYTE_ARRAY);
            this._buffers.setResponseHeaderType(Buffers.Type.BYTE_ARRAY);
        } else {
            this._buffers.setRequestBufferType(Buffers.Type.DIRECT);
            this._buffers.setRequestHeaderType(this._useDirectBuffers ? Buffers.Type.DIRECT : Buffers.Type.INDIRECT);
            this._buffers.setResponseBufferType(Buffers.Type.DIRECT);
            this._buffers.setResponseHeaderType(this._useDirectBuffers ? Buffers.Type.DIRECT : Buffers.Type.INDIRECT);
        }
    }

    public HttpClient() {
        this(new SslContextFactory());
    }

    public HttpClient(SslContextFactory sslContextFactory) {
        this._sslContextFactory = sslContextFactory;
        this.addBean(this._sslContextFactory);
        this.addBean(this._buffers);
    }

    public boolean isConnectBlocking() {
        return this._connectBlocking;
    }

    public void setConnectBlocking(boolean connectBlocking) {
        this._connectBlocking = connectBlocking;
    }

    public void send(HttpExchange exchange) throws IOException {
        boolean ssl = HttpSchemes.HTTPS_BUFFER.equalsIgnoreCase(exchange.getScheme());
        exchange.setStatus(1);
        HttpDestination destination = this.getDestination(exchange.getAddress(), ssl);
        destination.send(exchange);
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.removeBean(this._threadPool);
        this._threadPool = threadPool;
        this.addBean(this._threadPool);
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this._attributes.getAttributeNames();
    }

    @Override
    public void removeAttribute(String name) {
        this._attributes.removeAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object attribute) {
        this._attributes.setAttribute(name, attribute);
    }

    @Override
    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public HttpDestination getDestination(Address remote, boolean ssl) throws IOException {
        if (remote == null) {
            throw new UnknownHostException("Remote socket address cannot be null.");
        }
        HttpDestination destination = (HttpDestination)this._destinations.get(remote);
        if (destination == null) {
            HttpDestination other;
            destination = new HttpDestination(this, remote, ssl);
            if (!(this._proxy == null || this._noProxy != null && this._noProxy.contains(remote.getHost()))) {
                destination.setProxy(this._proxy);
                if (this._proxyAuthentication != null) {
                    destination.setProxyAuthentication(this._proxyAuthentication);
                }
            }
            if ((other = this._destinations.putIfAbsent(remote, destination)) != null) {
                destination = other;
            }
        }
        return destination;
    }

    public void schedule(Timeout.Task task) {
        this._timeoutQ.schedule(task);
    }

    public void schedule(Timeout.Task task, long timeout) {
        this._timeoutQ.schedule(task, timeout - this._timeoutQ.getDuration());
    }

    public void scheduleIdle(Timeout.Task task) {
        this._idleTimeoutQ.schedule(task);
    }

    public void cancel(Timeout.Task task) {
        task.cancel();
    }

    public boolean getUseDirectBuffers() {
        return this._useDirectBuffers;
    }

    public void setRealmResolver(RealmResolver resolver) {
        this._realmResolver = resolver;
    }

    public RealmResolver getRealmResolver() {
        return this._realmResolver;
    }

    public boolean hasRealms() {
        return this._realmResolver != null;
    }

    public void registerListener(String listenerClass) {
        if (this._registeredListeners == null) {
            this._registeredListeners = new LinkedList();
        }
        this._registeredListeners.add(listenerClass);
    }

    public LinkedList<String> getRegisteredListeners() {
        return this._registeredListeners;
    }

    public void setUseDirectBuffers(boolean direct) {
        this._useDirectBuffers = direct;
        this.setBufferTypes();
    }

    public int getConnectorType() {
        return this._connectorType;
    }

    public void setConnectorType(int connectorType) {
        this._connectorType = connectorType;
        this.setBufferTypes();
    }

    public int getMaxConnectionsPerAddress() {
        return this._maxConnectionsPerAddress;
    }

    public void setMaxConnectionsPerAddress(int maxConnectionsPerAddress) {
        this._maxConnectionsPerAddress = maxConnectionsPerAddress;
    }

    public int getMaxQueueSizePerAddress() {
        return this._maxQueueSizePerAddress;
    }

    public void setMaxQueueSizePerAddress(int maxQueueSizePerAddress) {
        this._maxQueueSizePerAddress = maxQueueSizePerAddress;
    }

    @Override
    protected void doStart() throws Exception {
        this.setBufferTypes();
        this._timeoutQ.setDuration(this._timeout);
        this._timeoutQ.setNow();
        this._idleTimeoutQ.setDuration(this._idleTimeout);
        this._idleTimeoutQ.setNow();
        if (this._threadPool == null) {
            LocalQueuedThreadPool pool = new LocalQueuedThreadPool();
            pool.setMaxThreads(16);
            pool.setDaemon(true);
            pool.setName("HttpClient");
            this._threadPool = pool;
            this.addBean(this._threadPool, true);
        }
        this._connector = (Connector)((Object)(this._connectorType == 2 ? new SelectConnector(this) : new SocketConnector(this)));
        this.addBean(this._connector, true);
        super.doStart();
        this._threadPool.dispatch(new Runnable(){

            @Override
            public void run() {
                while (HttpClient.this.isRunning()) {
                    HttpClient.this._timeoutQ.tick(System.currentTimeMillis());
                    HttpClient.this._idleTimeoutQ.tick(HttpClient.this._timeoutQ.getNow());
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
    }

    @Override
    protected void doStop() throws Exception {
        for (HttpDestination destination : this._destinations.values()) {
            destination.close();
        }
        this._timeoutQ.cancelAll();
        this._idleTimeoutQ.cancelAll();
        super.doStop();
        if (this._threadPool instanceof LocalQueuedThreadPool) {
            this.removeBean(this._threadPool);
            this._threadPool = null;
        }
        this.removeBean(this._connector);
    }

    protected SSLContext getSSLContext() {
        return this._sslContextFactory.getSslContext();
    }

    public SslContextFactory getSslContextFactory() {
        return this._sslContextFactory;
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setIdleTimeout(long ms) {
        this._idleTimeout = ms;
    }

    @Deprecated
    public int getSoTimeout() {
        return Long.valueOf(this.getTimeout()).intValue();
    }

    @Deprecated
    public void setSoTimeout(int timeout) {
        this.setTimeout(timeout);
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this._connectTimeout = connectTimeout;
    }

    public Address getProxy() {
        return this._proxy;
    }

    public void setProxy(Address proxy) {
        this._proxy = proxy;
    }

    public Authentication getProxyAuthentication() {
        return this._proxyAuthentication;
    }

    public void setProxyAuthentication(Authentication authentication) {
        this._proxyAuthentication = authentication;
    }

    public boolean isProxied() {
        return this._proxy != null;
    }

    public Set<String> getNoProxy() {
        return this._noProxy;
    }

    public void setNoProxy(Set<String> noProxyAddresses) {
        this._noProxy = noProxyAddresses;
    }

    public int maxRetries() {
        return this._maxRetries;
    }

    public void setMaxRetries(int retries) {
        this._maxRetries = retries;
    }

    public int maxRedirects() {
        return this._maxRedirects;
    }

    public void setMaxRedirects(int redirects) {
        this._maxRedirects = redirects;
    }

    @Override
    public int getRequestBufferSize() {
        return this._buffers.getRequestBufferSize();
    }

    @Override
    public void setRequestBufferSize(int requestBufferSize) {
        this._buffers.setRequestBufferSize(requestBufferSize);
    }

    @Override
    public int getRequestHeaderSize() {
        return this._buffers.getRequestHeaderSize();
    }

    @Override
    public void setRequestHeaderSize(int requestHeaderSize) {
        this._buffers.setRequestHeaderSize(requestHeaderSize);
    }

    @Override
    public int getResponseBufferSize() {
        return this._buffers.getResponseBufferSize();
    }

    @Override
    public void setResponseBufferSize(int responseBufferSize) {
        this._buffers.setResponseBufferSize(responseBufferSize);
    }

    @Override
    public int getResponseHeaderSize() {
        return this._buffers.getResponseHeaderSize();
    }

    @Override
    public void setResponseHeaderSize(int responseHeaderSize) {
        this._buffers.setResponseHeaderSize(responseHeaderSize);
    }

    @Override
    public Buffers.Type getRequestBufferType() {
        return this._buffers.getRequestBufferType();
    }

    @Override
    public Buffers.Type getRequestHeaderType() {
        return this._buffers.getRequestHeaderType();
    }

    @Override
    public Buffers.Type getResponseBufferType() {
        return this._buffers.getResponseBufferType();
    }

    @Override
    public Buffers.Type getResponseHeaderType() {
        return this._buffers.getResponseHeaderType();
    }

    @Override
    public void setRequestBuffers(Buffers requestBuffers) {
        this._buffers.setRequestBuffers(requestBuffers);
    }

    @Override
    public void setResponseBuffers(Buffers responseBuffers) {
        this._buffers.setResponseBuffers(responseBuffers);
    }

    @Override
    public Buffers getRequestBuffers() {
        return this._buffers.getRequestBuffers();
    }

    @Override
    public Buffers getResponseBuffers() {
        return this._buffers.getResponseBuffers();
    }

    @Override
    public void setMaxBuffers(int maxBuffers) {
        this._buffers.setMaxBuffers(maxBuffers);
    }

    @Override
    public int getMaxBuffers() {
        return this._buffers.getMaxBuffers();
    }

    @Deprecated
    public String getTrustStoreLocation() {
        return this._sslContextFactory.getTrustStore();
    }

    @Deprecated
    public void setTrustStoreLocation(String trustStoreLocation) {
        this._sslContextFactory.setTrustStore(trustStoreLocation);
    }

    @Deprecated
    public InputStream getTrustStoreInputStream() {
        return this._sslContextFactory.getTrustStoreInputStream();
    }

    @Deprecated
    public void setTrustStoreInputStream(InputStream trustStoreInputStream) {
        this._sslContextFactory.setTrustStoreInputStream(trustStoreInputStream);
    }

    @Deprecated
    public String getKeyStoreLocation() {
        return this._sslContextFactory.getKeyStorePath();
    }

    @Deprecated
    public void setKeyStoreLocation(String keyStoreLocation) {
        this._sslContextFactory.setKeyStorePath(keyStoreLocation);
    }

    @Deprecated
    public InputStream getKeyStoreInputStream() {
        return this._sslContextFactory.getKeyStoreInputStream();
    }

    @Deprecated
    public void setKeyStoreInputStream(InputStream keyStoreInputStream) {
        this._sslContextFactory.setKeyStoreInputStream(keyStoreInputStream);
    }

    @Deprecated
    public void setKeyStorePassword(String keyStorePassword) {
        this._sslContextFactory.setKeyStorePassword(keyStorePassword);
    }

    @Deprecated
    public void setKeyManagerPassword(String keyManagerPassword) {
        this._sslContextFactory.setKeyManagerPassword(keyManagerPassword);
    }

    @Deprecated
    public void setTrustStorePassword(String trustStorePassword) {
        this._sslContextFactory.setTrustStorePassword(trustStorePassword);
    }

    @Deprecated
    public String getKeyStoreType() {
        return this._sslContextFactory.getKeyStoreType();
    }

    @Deprecated
    public void setKeyStoreType(String keyStoreType) {
        this._sslContextFactory.setKeyStoreType(keyStoreType);
    }

    @Deprecated
    public String getTrustStoreType() {
        return this._sslContextFactory.getTrustStoreType();
    }

    @Deprecated
    public void setTrustStoreType(String trustStoreType) {
        this._sslContextFactory.setTrustStoreType(trustStoreType);
    }

    @Deprecated
    public String getKeyManagerAlgorithm() {
        return this._sslContextFactory.getSslKeyManagerFactoryAlgorithm();
    }

    @Deprecated
    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this._sslContextFactory.setSslKeyManagerFactoryAlgorithm(keyManagerAlgorithm);
    }

    @Deprecated
    public String getTrustManagerAlgorithm() {
        return this._sslContextFactory.getTrustManagerFactoryAlgorithm();
    }

    @Deprecated
    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this._sslContextFactory.setTrustManagerFactoryAlgorithm(trustManagerAlgorithm);
    }

    @Deprecated
    public String getProtocol() {
        return this._sslContextFactory.getProtocol();
    }

    @Deprecated
    public void setProtocol(String protocol) {
        this._sslContextFactory.setProtocol(protocol);
    }

    @Deprecated
    public String getProvider() {
        return this._sslContextFactory.getProvider();
    }

    @Deprecated
    public void setProvider(String provider) {
        this.setProvider(provider);
    }

    @Deprecated
    public String getSecureRandomAlgorithm() {
        return this._sslContextFactory.getSecureRandomAlgorithm();
    }

    @Deprecated
    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this._sslContextFactory.setSecureRandomAlgorithm(secureRandomAlgorithm);
    }

    private static class LocalQueuedThreadPool
    extends QueuedThreadPool {
        private LocalQueuedThreadPool() {
        }
    }

    static interface Connector
    extends LifeCycle {
        public void startConnection(HttpDestination var1) throws IOException;
    }
}

