/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ThreadLocalBuffers;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.io.nio.SslSelectChannelEndPoint;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;

class SelectConnector
extends AbstractLifeCycle
implements HttpClient.Connector,
Runnable {
    private final HttpClient _httpClient;
    private final Manager _selectorManager = new Manager();
    private final Timeout _connectTimer = new Timeout();
    private final Map<SocketChannel, Timeout.Task> _connectingChannels = new ConcurrentHashMap<SocketChannel, Timeout.Task>();
    private SSLContext _sslContext;
    private Buffers _sslBuffers;
    private boolean _blockingConnect;

    SelectConnector(HttpClient httpClient) {
        this._httpClient = httpClient;
    }

    public boolean isBlockingConnect() {
        return this._blockingConnect;
    }

    public void setBlockingConnect(boolean blockingConnect) {
        this._blockingConnect = blockingConnect;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this._connectTimer.setDuration(this._httpClient.getConnectTimeout());
        this._connectTimer.setNow();
        this._httpClient._threadPool.dispatch(new Runnable(){

            @Override
            public void run() {
                while (SelectConnector.this.isRunning()) {
                    SelectConnector.this._connectTimer.tick(System.currentTimeMillis());
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException x) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
        });
        this._selectorManager.start();
        final boolean direct = this._httpClient.getUseDirectBuffers();
        SSLEngine sslEngine = this._selectorManager.newSslEngine();
        final SSLSession ssl_session = sslEngine.getSession();
        ThreadLocalBuffers ssl_buffers = new ThreadLocalBuffers(){
            {
                super.setBufferSize(ssl_session.getApplicationBufferSize());
                super.setHeaderSize(ssl_session.getApplicationBufferSize());
            }

            @Override
            protected Buffer newBuffer(int size) {
                return direct ? new DirectNIOBuffer(size) : new IndirectNIOBuffer(size);
            }

            @Override
            protected Buffer newHeader(int size) {
                return direct ? new DirectNIOBuffer(size) : new IndirectNIOBuffer(size);
            }

            @Override
            protected boolean isHeader(Buffer buffer) {
                return true;
            }

            @Override
            public void setBufferSize(int size) {
            }

            @Override
            public void setHeaderSize(int size) {
            }
        };
        this._sslBuffers = ssl_buffers;
        this._httpClient._threadPool.dispatch(this);
    }

    @Override
    protected void doStop() throws Exception {
        this._connectTimer.cancelAll();
        this._selectorManager.stop();
    }

    @Override
    public void startConnection(HttpDestination destination) throws IOException {
        SocketChannel channel = SocketChannel.open();
        Address address = destination.isProxied() ? destination.getProxy() : destination.getAddress();
        channel.configureBlocking(false);
        channel.socket().setTcpNoDelay(true);
        channel.connect(address.toSocketAddress());
        this._selectorManager.register(channel, destination);
        ConnectTimeout connectTimeout = new ConnectTimeout(channel, destination);
        this._connectTimer.schedule(connectTimeout);
        this._connectingChannels.put(channel, connectTimeout);
    }

    @Override
    public void run() {
        while (this._httpClient.isRunning()) {
            try {
                this._selectorManager.doSelect(0);
            }
            catch (Exception e) {
                Log.warn(e.toString());
                Log.debug(e);
                Thread.yield();
            }
        }
    }

    private class ConnectTimeout
    extends Timeout.Task {
        private final SocketChannel channel;
        private final HttpDestination destination;

        public ConnectTimeout(SocketChannel channel, HttpDestination destination) {
            this.channel = channel;
            this.destination = destination;
        }

        @Override
        public void expired() {
            SelectConnector.this._connectingChannels.remove(this.channel);
            if (this.channel.isConnectionPending()) {
                Log.debug("Channel {} timed out while connecting, closing it", this.channel);
                try {
                    this.channel.close();
                }
                catch (IOException x) {
                    Log.ignore(x);
                }
                this.destination.onConnectionFailed(new SocketTimeoutException());
            }
        }
    }

    class Manager
    extends SelectorManager {
        Manager() {
        }

        @Override
        protected SocketChannel acceptChannel(SelectionKey key) throws IOException {
            throw new IllegalStateException();
        }

        @Override
        public boolean dispatch(Runnable task) {
            return ((SelectConnector)SelectConnector.this)._httpClient._threadPool.dispatch(task);
        }

        @Override
        protected void endPointOpened(SelectChannelEndPoint endpoint) {
        }

        @Override
        protected void endPointClosed(SelectChannelEndPoint endpoint) {
        }

        @Override
        protected void endPointUpgraded(ConnectedEndPoint endpoint, Connection oldConnection) {
        }

        @Override
        protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
            if (endpoint instanceof SslSelectChannelEndPoint) {
                return new HttpConnection(SelectConnector.this._sslBuffers, SelectConnector.this._sslBuffers, endpoint);
            }
            return new HttpConnection(SelectConnector.this._httpClient.getRequestBuffers(), SelectConnector.this._httpClient.getResponseBuffers(), endpoint);
        }

        @Override
        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
            Timeout.Task connectTimeout = (Timeout.Task)SelectConnector.this._connectingChannels.remove(channel);
            if (connectTimeout != null) {
                connectTimeout.cancel();
            }
            Log.debug("Channels with connection pending: {}", SelectConnector.this._connectingChannels.size());
            HttpDestination dest = (HttpDestination)key.attachment();
            SelectChannelEndPoint ep = null;
            if (dest.isSecure()) {
                if (dest.isProxied()) {
                    String connect = "CONNECT " + dest.getAddress() + "HTTP/1.0" + "\r\n\r\n";
                    throw new IllegalStateException("Not Implemented");
                }
                SSLEngine engine = this.newSslEngine();
                ep = new SslSelectChannelEndPoint(SelectConnector.this._sslBuffers, channel, selectSet, key, engine);
            } else {
                ep = new SelectChannelEndPoint(channel, selectSet, key);
            }
            HttpConnection connection = (HttpConnection)ep.getConnection();
            connection.setDestination(dest);
            dest.onNewConnection(connection);
            return ep;
        }

        private synchronized SSLEngine newSslEngine() throws IOException {
            if (SelectConnector.this._sslContext == null) {
                SelectConnector.this._sslContext = SelectConnector.this._httpClient.getSSLContext();
            }
            SSLEngine sslEngine = SelectConnector.this._sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            sslEngine.beginHandshake();
            return sslEngine;
        }

        @Override
        protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
            if (attachment instanceof HttpDestination) {
                ((HttpDestination)attachment).onConnectionFailed(ex);
            } else {
                super.connectionFailed(channel, ex, attachment);
            }
        }
    }
}

