/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import java.util.Random;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.RunAsCollection;
import org.eclipse.jetty.plus.jndi.Transaction;
import org.eclipse.jetty.plus.webapp.PlusDescriptorProcessor;
import org.eclipse.jetty.plus.webapp.WebAppDecorator;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.Fragment;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlProcessor;

public class Configuration
implements org.eclipse.jetty.webapp.Configuration {
    private Integer _key;

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        LifeCycleCallbackCollection callbacks = new LifeCycleCallbackCollection();
        context.setAttribute("org.eclipse.jetty.lifecyleCallbackCollection", callbacks);
        InjectionCollection injections = new InjectionCollection();
        context.setAttribute("org.eclipse.jetty.injectionCollection", injections);
        RunAsCollection runAsCollection = new RunAsCollection();
        context.setAttribute("org.eclipse.jetty.runAsCollection", runAsCollection);
        WebAppDecorator decorator = new WebAppDecorator(context);
        context.setDecorator(decorator);
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        this.bindUserTransaction(context);
        WebXmlProcessor webXmlProcessor = (WebXmlProcessor)context.getAttribute("org.eclipse.jetty.webProcessor");
        if (webXmlProcessor == null) {
            throw new IllegalStateException("No processor for web xml");
        }
        PlusDescriptorProcessor plusProcessor = new PlusDescriptorProcessor(webXmlProcessor);
        webXmlProcessor.process(webXmlProcessor.getWebDefault(), plusProcessor);
        webXmlProcessor.process(webXmlProcessor.getWebXml(), plusProcessor);
        for (Fragment frag : webXmlProcessor.getFragments()) {
            webXmlProcessor.process(frag, plusProcessor);
        }
        webXmlProcessor.process(webXmlProcessor.getOverrideWeb(), plusProcessor);
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        this.lockCompEnv(context);
        context.setAttribute("org.eclipse.jetty.lifecyleCallbackCollection", null);
        context.setAttribute("org.eclipse.jetty.injectionCollection", null);
        context.setAttribute("org.eclipse.jetty.runAsCollection", null);
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        this.unlockCompEnv(context);
        this._key = null;
    }

    public void bindUserTransaction(WebAppContext context) throws Exception {
        try {
            Transaction.bindToENC();
        }
        catch (NameNotFoundException e) {
            Log.info("No Transaction manager found - if your webapp requires one, please configure one.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockCompEnv(WebAppContext wac) throws Exception {
        ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wac.getClassLoader());
        try {
            Random random = new Random();
            this._key = new Integer(random.nextInt());
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.addToEnvironment("org.eclipse.jndi.lock", this._key);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old_loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockCompEnv(WebAppContext wac) throws Exception {
        if (this._key != null) {
            ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(wac.getClassLoader());
            try {
                InitialContext context = new InitialContext();
                Context compCtx = (Context)context.lookup("java:comp");
                compCtx.addToEnvironment("org.eclipse.jndi.unlock", this._key);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old_loader);
            }
        }
    }
}

