/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.Util;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebServletAnnotationHandler
implements AnnotationParser.DiscoverableAnnotationHandler {
    protected WebAppContext _wac;

    public WebServletAnnotationHandler(WebAppContext wac) {
        this._wac = wac;
    }

    @Override
    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotationName, List<AnnotationParser.Value> values) {
        Class clazz;
        if (!"javax.servlet.annotation.WebServlet".equals(annotationName)) {
            return;
        }
        try {
            clazz = Loader.loadClass(null, className);
        }
        catch (Exception e) {
            Log.warn(e);
            return;
        }
        if (!HttpServlet.class.isAssignableFrom(clazz)) {
            Log.warn(clazz.getName() + " is not assignable from javax.servlet.http.HttpServlet");
            return;
        }
        WebServlet annotation = clazz.getAnnotation(WebServlet.class);
        if (annotation.urlPatterns().length > 0 && annotation.value().length > 0) {
            Log.warn(clazz.getName() + " defines both @WebServlet.value and @WebServlet.urlPatterns");
            return;
        }
        String[] urlPatterns = annotation.value();
        if (urlPatterns.length == 0) {
            urlPatterns = annotation.urlPatterns();
        }
        if (urlPatterns.length == 0) {
            Log.warn(clazz.getName() + " defines neither @WebServlet.value nor @WebServlet.urlPatterns");
            return;
        }
        ArrayList<String> urlPatternList = new ArrayList<String>();
        for (String p : urlPatterns) {
            urlPatternList.add(Util.normalizePattern(p));
        }
        String servletName = annotation.name().equals("") ? clazz.getName() : annotation.name();
        ServletHolder[] holders = this._wac.getServletHandler().getServlets();
        boolean isNew = true;
        ServletHolder holder = null;
        if (holders != null) {
            for (ServletHolder servletHolder : holders) {
                if (!servletHolder.getClassName().equals(clazz.getName()) || !servletHolder.getName().equals(servletName)) continue;
                holder = servletHolder;
                isNew = false;
                break;
            }
        }
        if (isNew) {
            holder = this._wac.getServletHandler().newServletHolder(Holder.Source.ANNOTATION);
            holder.setHeldClass(clazz);
            holder.setName(servletName);
            holder.setDisplayName(annotation.displayName());
            holder.setInitOrder(annotation.loadOnStartup());
            holder.setAsyncSupported(annotation.asyncSupported());
            for (ServletHolder servletHolder : annotation.initParams()) {
                holder.setInitParameter(servletHolder.name(), servletHolder.value());
            }
            this._wac.getServletHandler().addServlet(holder);
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(holder.getName());
            mapping.setPathSpecs(LazyList.toStringArray(urlPatternList));
            this._wac.getServletHandler().addServletMapping(mapping);
        } else {
            for (ServletHolder servletHolder : annotation.initParams()) {
                if (holder.getInitParameter(servletHolder.name()) != null) continue;
                holder.setInitParameter(servletHolder.name(), servletHolder.value());
            }
            ServletMapping[] mappings = this._wac.getServletHandler().getServletMappings();
            if (mappings == null) {
                ServletMapping mapping = new ServletMapping();
                mapping.setServletName(servletName);
                mapping.setPathSpecs(LazyList.toStringArray(urlPatternList));
                this._wac.getServletHandler().addServletMapping(mapping);
            }
        }
    }

    @Override
    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        Log.warn("@WebServlet annotation not supported for fields");
    }

    @Override
    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        Log.warn("@WebServlet annotation not supported for methods");
    }
}

