/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.naming.NamingException;
import org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

public class ResourcesAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    protected WebAppContext _wac;

    public ResourcesAnnotationHandler(WebAppContext wac) {
        super(true);
        this._wac = wac;
    }

    @Override
    public void doHandle(Class clazz) {
        Resources resources = clazz.getAnnotation(Resources.class);
        if (resources != null) {
            Resource[] resArray = resources.value();
            if (resArray == null || resArray.length == 0) {
                Log.warn("Skipping empty or incorrect Resources annotation on " + clazz.getName());
                return;
            }
            for (int j = 0; j < resArray.length; ++j) {
                String name = resArray[j].name();
                String mappedName = resArray[j].mappedName();
                Resource.AuthenticationType auth = resArray[j].authenticationType();
                Class type = resArray[j].type();
                boolean shareable = resArray[j].shareable();
                if (name == null || name.trim().equals("")) {
                    throw new IllegalStateException("Class level Resource annotations must contain a name (Common Annotations Spec Section 2.3)");
                }
                try {
                    if (NamingEntryUtil.bindToENC(this._wac, name, mappedName) || NamingEntryUtil.bindToENC(this._wac.getServer(), name, mappedName)) continue;
                    Log.warn("Skipping Resources(Resource) annotation on " + clazz.getName() + " for name " + name + ": No resource bound at " + (mappedName == null ? name : mappedName));
                    continue;
                }
                catch (NamingException e) {
                    Log.warn(e);
                }
            }
        }
    }
}

