/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.NIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SslSelectChannelEndPoint
extends SelectChannelEndPoint {
    public static final Logger LOG = Log.getLogger("org.eclipse.jetty.io.nio").getLogger("ssl");
    private static final Buffer __EMPTY_BUFFER = new DirectNIOBuffer(0);
    private static final ByteBuffer __ZERO_BUFFER = ByteBuffer.allocate(0);
    private final Buffers _buffers;
    private final SSLEngine _engine;
    private final SSLSession _session;
    private volatile NIOBuffer _inNIOBuffer;
    private volatile NIOBuffer _outNIOBuffer;
    private boolean _closing = false;
    private SSLEngineResult _result;
    private volatile boolean _handshook = false;
    private boolean _allowRenegotiate = true;
    private volatile boolean _debug = LOG.isDebugEnabled();

    public SslSelectChannelEndPoint(Buffers buffers, SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key, SSLEngine engine, int maxIdleTime) throws IOException {
        super(channel, selectSet, key, maxIdleTime);
        this._buffers = buffers;
        this._engine = engine;
        this._session = engine.getSession();
        if (this._debug) {
            LOG.debug(this._session + " channel=" + channel, new Object[0]);
        }
    }

    public SslSelectChannelEndPoint(Buffers buffers, SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key, SSLEngine engine) throws IOException {
        super(channel, selectSet, key);
        this._buffers = buffers;
        this._engine = engine;
        this._session = engine.getSession();
        if (this._debug) {
            LOG.debug(this._session + " channel=" + channel, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void needOutBuffer() {
        SslSelectChannelEndPoint sslSelectChannelEndPoint = this;
        synchronized (sslSelectChannelEndPoint) {
            if (this._outNIOBuffer == null) {
                this._outNIOBuffer = (NIOBuffer)this._buffers.getBuffer(this._session.getPacketBufferSize());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeOutBuffer() {
        SslSelectChannelEndPoint sslSelectChannelEndPoint = this;
        synchronized (sslSelectChannelEndPoint) {
            if (this._outNIOBuffer != null && this._outNIOBuffer.length() == 0) {
                this._buffers.returnBuffer(this._outNIOBuffer);
                this._outNIOBuffer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void needInBuffer() {
        SslSelectChannelEndPoint sslSelectChannelEndPoint = this;
        synchronized (sslSelectChannelEndPoint) {
            if (this._inNIOBuffer == null) {
                this._inNIOBuffer = (NIOBuffer)this._buffers.getBuffer(this._session.getPacketBufferSize());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeInBuffer() {
        SslSelectChannelEndPoint sslSelectChannelEndPoint = this;
        synchronized (sslSelectChannelEndPoint) {
            if (this._inNIOBuffer != null && this._inNIOBuffer.length() == 0) {
                this._buffers.returnBuffer(this._inNIOBuffer);
                this._inNIOBuffer = null;
            }
        }
    }

    public boolean isProgressing() {
        SSLEngineResult result = this._result;
        this._result = null;
        return result != null && (result.bytesConsumed() > 0 || result.bytesProduced() > 0);
    }

    public boolean isAllowRenegotiate() {
        return this._allowRenegotiate;
    }

    public void setAllowRenegotiate(boolean allowRenegotiate) {
        this._allowRenegotiate = allowRenegotiate;
    }

    public boolean isOutputShutdown() {
        return this._engine != null && this._engine.isOutboundDone();
    }

    public boolean isInputShutdown() {
        return this._engine != null && this._engine.isInboundDone();
    }

    public void shutdownOutput() throws IOException {
        LOG.debug("{} shutdownOutput", this._session);
        this.close();
    }

    private int process(ByteBuffer inBBuf, Buffer outBuf) throws IOException {
        if (this._debug) {
            LOG.debug("{} process closing={} in={} out={}", this._session, this._closing, inBBuf, outBuf);
        }
        if (inBBuf == null) {
            inBBuf = __ZERO_BUFFER;
        }
        int received = 0;
        int sent = 0;
        SSLEngineResult.HandshakeStatus initialStatus = this._engine.getHandshakeStatus();
        boolean progress = true;
        while (progress) {
            progress = false;
            int len = this._outNIOBuffer == null ? 0 : this._outNIOBuffer.length();
            this.flush();
            progress |= (this._outNIOBuffer == null ? 0 : this._outNIOBuffer.length()) < len;
            if (this._debug) {
                LOG.debug("status {} {}", new Object[]{this._engine, this._engine.getHandshakeStatus()});
            }
            switch (this._engine.getHandshakeStatus()) {
                case FINISHED: {
                    throw new IllegalStateException();
                }
                case NOT_HANDSHAKING: {
                    if (this._closing) {
                        if (outBuf == null || !outBuf.hasContent()) break;
                        LOG.debug("Write while closing", new Object[0]);
                        outBuf.clear();
                        break;
                    }
                    if (outBuf != null && outBuf.hasContent()) {
                        int c = this.wrap(outBuf);
                        boolean bl = progress = c > 0 || this._result.bytesProduced() > 0 || this._result.bytesConsumed() > 0;
                        if (c > 0) {
                            sent += c;
                        } else if (c < 0 && sent == 0) {
                            sent = -1;
                        }
                    }
                    if (inBBuf.remaining() <= 0 || this._inNIOBuffer == null || !this._inNIOBuffer.hasContent()) break;
                    int space = inBBuf.remaining();
                    progress |= this.unwrap(inBBuf);
                    received += space - inBBuf.remaining();
                    break;
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = this._engine.getDelegatedTask()) != null) {
                        progress = true;
                        task.run();
                    }
                    if (initialStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || this._engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || sent != 0) break;
                    if (this._debug) {
                        LOG.warn("{} JETTY-567", this._session);
                    }
                    return -1;
                }
                case NEED_WRAP: {
                    this.checkRenegotiate();
                    int c = 0;
                    c = outBuf != null && outBuf.hasContent() ? this.wrap(outBuf) : this.wrap(__EMPTY_BUFFER);
                    boolean bl = progress = this._result.bytesProduced() > 0 || this._result.bytesConsumed() > 0;
                    if (c > 0) {
                        sent += c;
                        break;
                    }
                    if (c >= 0 || sent != 0) break;
                    sent = -1;
                    break;
                }
                case NEED_UNWRAP: {
                    this.checkRenegotiate();
                    progress |= this.unwrap(inBBuf);
                    if (!this._closing || !inBBuf.hasRemaining()) break;
                    inBBuf.clear();
                }
            }
            if (!this._debug) continue;
            LOG.debug("{} progress {}", this._session, progress);
        }
        if (this._debug) {
            LOG.debug("{} received {} sent {}", this._session, received, sent);
        }
        this.freeInBuffer();
        return received < 0 || sent < 0 ? -1 : received + sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (!this._closing) {
                this._closing = true;
                LOG.debug("{} close", this._session);
                this._engine.closeOutbound();
                this.process(null, null);
            }
        }
        catch (IOException e) {
            LOG.ignore(e);
        }
        finally {
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(Buffer buffer) throws IOException {
        this._debug = LOG.isDebugEnabled();
        LOG.debug("{} fill", this._session);
        ByteBuffer bbuf = ((NIOBuffer)buffer).getByteBuffer();
        int size = buffer.length();
        ByteBuffer byteBuffer = bbuf;
        synchronized (byteBuffer) {
            bbuf.position(buffer.putIndex());
            try {
                this.unwrap(bbuf);
                this.process(bbuf, null);
            }
            finally {
                buffer.setPutIndex(bbuf.position());
                bbuf.position(0);
            }
        }
        int filled = buffer.length() - size;
        if (filled == 0 && (this.isInputShutdown() || !this.isOpen())) {
            return -1;
        }
        return filled;
    }

    public int flush(Buffer buffer) throws IOException {
        this._debug = LOG.isDebugEnabled();
        LOG.debug("{} flush1", this._session);
        return this.process(null, buffer);
    }

    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        this._debug = LOG.isDebugEnabled();
        LOG.debug("{} flush3", this._session);
        int len = 0;
        int flushed = 0;
        if (header != null && header.hasContent()) {
            len = header.length();
            flushed = this.flush(header);
        }
        if (flushed == len && buffer != null && buffer.hasContent()) {
            int f = this.flush(buffer);
            if (f >= 0) {
                flushed += f;
            } else if (flushed == 0) {
                flushed = -1;
            }
        }
        return flushed;
    }

    public void flush() throws IOException {
        LOG.debug("{} flush", this._session);
        if (!this.isOpen()) {
            throw new EofException();
        }
        if (this.isBufferingOutput()) {
            int flushed = super.flush(this._outNIOBuffer);
            if (this._debug) {
                LOG.debug("{} flushed={} left={}", this._session, flushed, this._outNIOBuffer.length());
            }
        } else if (this._engine.isOutboundDone() && super.isOpen()) {
            if (this._debug) {
                LOG.debug("{} flush shutdownOutput", this._session);
            }
            try {
                super.shutdownOutput();
            }
            catch (IOException e) {
                LOG.ignore(e);
            }
        }
        this.freeOutBuffer();
    }

    private void checkRenegotiate() throws IOException {
        if (this._handshook && !this._allowRenegotiate && this._channel != null && this._channel.isOpen()) {
            LOG.warn("SSL renegotiate denied: {}", this._channel);
            super.close();
        }
    }

    private boolean unwrap(ByteBuffer buffer) throws IOException {
        this.needInBuffer();
        ByteBuffer in_buffer = this._inNIOBuffer.getByteBuffer();
        this._inNIOBuffer.compact();
        int total_filled = 0;
        boolean remoteClosed = false;
        LOG.debug("{} unwrap space={} open={}", this._session, this._inNIOBuffer.space(), super.isOpen());
        while (this._inNIOBuffer.space() > 0 && super.isOpen()) {
            int filled = super.fill(this._inNIOBuffer);
            if (this._debug) {
                LOG.debug("{} filled {}", this._session, filled);
            }
            if (filled < 0) {
                remoteClosed = true;
            }
            if (filled <= 0) break;
            total_filled += filled;
        }
        if (total_filled == 0 && this._inNIOBuffer.length() == 0) {
            if (this.isOpen() && remoteClosed) {
                try {
                    this._engine.closeInbound();
                }
                catch (SSLException x) {
                    super.close();
                }
            }
            if (!this.isOpen()) {
                throw new EofException();
            }
            return false;
        }
        try {
            in_buffer.position(this._inNIOBuffer.getIndex());
            in_buffer.limit(this._inNIOBuffer.putIndex());
            this._result = this._engine.unwrap(in_buffer, buffer);
            if (!this._handshook && this._result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                this._handshook = true;
            }
            if (this._debug) {
                LOG.debug("{} unwrap {}", this._session, this._result);
            }
            this._inNIOBuffer.skip(this._result.bytesConsumed());
        }
        catch (SSLException e) {
            LOG.warn(this.getRemoteAddr() + ":" + this.getRemotePort() + " ", e);
            super.close();
            throw e;
        }
        finally {
            in_buffer.position(0);
            in_buffer.limit(in_buffer.capacity());
        }
        switch (this._result.getStatus()) {
            case BUFFER_OVERFLOW: {
                LOG.debug("{} unwrap overflow", this._session);
                return false;
            }
            case BUFFER_UNDERFLOW: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} unwrap {}", this._session, this._result);
                }
                if (!this.isOpen()) {
                    this._inNIOBuffer.clear();
                    if (this._outNIOBuffer != null) {
                        this._outNIOBuffer.clear();
                    }
                    throw new EofException();
                }
                return total_filled > 0;
            }
            case CLOSED: {
                this._closing = true;
                return total_filled > 0 || this._result.bytesConsumed() > 0 || this._result.bytesProduced() > 0;
            }
            case OK: {
                return total_filled > 0 || this._result.bytesConsumed() > 0 || this._result.bytesProduced() > 0;
            }
        }
        LOG.warn("{} unwrap default: {}", this._session, this._result);
        throw new IOException(this._result.toString());
    }

    private ByteBuffer extractOutputBuffer(Buffer buffer) {
        if (buffer.buffer() instanceof NIOBuffer) {
            return ((NIOBuffer)buffer.buffer()).getByteBuffer();
        }
        return ByteBuffer.wrap(buffer.array());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int wrap(Buffer buffer) throws IOException {
        ByteBuffer bbuf;
        ByteBuffer byteBuffer = bbuf = this.extractOutputBuffer(buffer);
        synchronized (byteBuffer) {
            ByteBuffer out_buffer;
            int consumed = 0;
            this.needOutBuffer();
            this._outNIOBuffer.compact();
            ByteBuffer byteBuffer2 = out_buffer = this._outNIOBuffer.getByteBuffer();
            synchronized (byteBuffer2) {
                try {
                    bbuf.position(buffer.getIndex());
                    bbuf.limit(buffer.putIndex());
                    out_buffer.position(this._outNIOBuffer.putIndex());
                    out_buffer.limit(out_buffer.capacity());
                    this._result = this._engine.wrap(bbuf, out_buffer);
                    if (this._debug) {
                        LOG.debug("{} wrap {}", this._session, this._result);
                    }
                    if (!this._handshook && this._result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                        this._handshook = true;
                    }
                    this._outNIOBuffer.setPutIndex(out_buffer.position());
                    consumed = this._result.bytesConsumed();
                    out_buffer.position(0);
                }
                catch (SSLException e) {
                    try {
                        LOG.warn(this.getRemoteAddr() + ":" + this.getRemotePort() + " ", e);
                        if (this.getChannel().isOpen()) {
                            this.getChannel().close();
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        out_buffer.position(0);
                        bbuf.position(0);
                        bbuf.limit(bbuf.capacity());
                        if (consumed > 0) {
                            int len = consumed < buffer.length() ? consumed : buffer.length();
                            buffer.skip(len);
                            consumed -= len;
                        }
                        throw throwable;
                    }
                }
                bbuf.position(0);
                bbuf.limit(bbuf.capacity());
                if (consumed > 0) {
                    int len = consumed < buffer.length() ? consumed : buffer.length();
                    buffer.skip(len);
                    consumed -= len;
                }
            }
        }
        switch (this._result.getStatus()) {
            case BUFFER_UNDERFLOW: {
                throw new IllegalStateException();
            }
            case BUFFER_OVERFLOW: {
                LOG.debug("{} wrap {}", this._session, this._result);
                this.flush();
                return 0;
            }
            case OK: {
                return this._result.bytesConsumed();
            }
            case CLOSED: {
                this._closing = true;
                return this._result.bytesConsumed() > 0 ? this._result.bytesConsumed() : -1;
            }
        }
        LOG.warn("{} wrap default {}", this._session, this._result);
        throw new IOException(this._result.toString());
    }

    public boolean isBufferingInput() {
        NIOBuffer in = this._inNIOBuffer;
        return in != null && in.hasContent();
    }

    public boolean isBufferingOutput() {
        NIOBuffer out = this._outNIOBuffer;
        return out != null && out.hasContent();
    }

    public boolean isBufferred() {
        return true;
    }

    public SSLEngine getSSLEngine() {
        return this._engine;
    }

    public String toString() {
        NIOBuffer i = this._inNIOBuffer;
        NIOBuffer o = this._outNIOBuffer;
        return "SSL" + super.toString() + "," + (this._engine == null ? "-" : this._engine.getHandshakeStatus()) + ", in/out=" + (i == null ? 0 : i.length()) + "/" + (o == null ? 0 : o.length()) + " bi/o=" + this.isBufferingInput() + "/" + this.isBufferingOutput() + " " + this._result;
    }
}

