/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jaas.spi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.http.security.Credential;
import org.eclipse.jetty.plus.jaas.spi.AbstractLoginModule;
import org.eclipse.jetty.plus.jaas.spi.UserInfo;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatabaseLoginModule
extends AbstractLoginModule {
    private static final Logger LOG = Log.getLogger(AbstractDatabaseLoginModule.class);
    private String userQuery;
    private String rolesQuery;
    private String dbUserTable;
    private String dbUserTableUserField;
    private String dbUserTableCredentialField;
    private String dbUserRoleTable;
    private String dbUserRoleTableUserField;
    private String dbUserRoleTableRoleField;

    public abstract Connection getConnection() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getUserInfo(String userName) throws Exception {
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement statement = connection.prepareStatement(this.userQuery);
            statement.setString(1, userName);
            ResultSet results = statement.executeQuery();
            String dbCredential = null;
            if (results.next()) {
                dbCredential = results.getString(1);
            }
            results.close();
            statement.close();
            statement = connection.prepareStatement(this.rolesQuery);
            statement.setString(1, userName);
            results = statement.executeQuery();
            ArrayList<String> roles = new ArrayList<String>();
            while (results.next()) {
                String roleName = results.getString(1);
                roles.add(roleName);
            }
            results.close();
            statement.close();
            UserInfo userInfo = dbCredential == null ? null : new UserInfo(userName, Credential.getCredential(dbCredential), roles);
            return userInfo;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dbUserTable = (String)options.get("userTable");
        this.dbUserTableUserField = (String)options.get("userField");
        this.dbUserTableCredentialField = (String)options.get("credentialField");
        this.userQuery = "select " + this.dbUserTableCredentialField + " from " + this.dbUserTable + " where " + this.dbUserTableUserField + "=?";
        this.dbUserRoleTable = (String)options.get("userRoleTable");
        this.dbUserRoleTableUserField = (String)options.get("userRoleUserField");
        this.dbUserRoleTableRoleField = (String)options.get("userRoleRoleField");
        this.rolesQuery = "select " + this.dbUserRoleTableRoleField + " from " + this.dbUserRoleTable + " where " + this.dbUserRoleTableUserField + "=?";
        if (LOG.isDebugEnabled()) {
            LOG.debug("userQuery = " + this.userQuery, new Object[0]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("rolesQuery = " + this.rolesQuery, new Object[0]);
        }
    }
}

