/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.UnavailableException;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebXmlProcessor {
    public static final String WEB_PROCESSOR = "org.eclipse.jetty.webProcessor";
    public static final String METADATA_COMPLETE = "org.eclipse.jetty.metadataComplete";
    public static final String WEBXML_VERSION = "org.eclipse.jetty.webXmlVersion";
    public static final String WEBXML_CLASSNAMES = "org.eclipse.jetty.webXmlClassNames";
    protected WebAppContext _context;
    protected XmlParser _xmlParser;
    protected Descriptor _webDefaultsRoot;
    protected Descriptor _webXmlRoot;
    protected List<Descriptor> _webFragmentRoots = new ArrayList<Descriptor>();
    protected Descriptor _webOverrideRoot;
    protected ServletHandler _servletHandler;
    protected SecurityHandler _securityHandler;
    protected Object _filters;
    protected Object _filterMappings;
    protected Object _servlets;
    protected Object _servletMappings;
    protected Object _listeners;
    protected Object _welcomeFiles;
    protected Set<String> _roles = new HashSet<String>();
    protected Object _constraintMappings;
    protected Map _errorPages;
    protected boolean _hasJSP;
    protected String _jspServletName;
    protected String _jspServletClass;
    protected boolean _defaultWelcomeFileList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlParser webXmlParser() throws ClassNotFoundException {
        XmlParser xmlParser = new XmlParser();
        URL dtd22 = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_2.dtd", true);
        URL dtd23 = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_3.dtd", true);
        URL j2ee14xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/j2ee_1_4.xsd", true);
        URL webapp24xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_4.xsd", true);
        URL webapp25xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_5.xsd", true);
        URL webapp30xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_3_0.xsd", true);
        URL webcommon30xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-common_3_0.xsd", true);
        URL webfragment30xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-fragment_3_0.xsd", true);
        URL schemadtd = Loader.getResource(Servlet.class, "javax/servlet/resources/XMLSchema.dtd", true);
        URL xmlxsd = Loader.getResource(Servlet.class, "javax/servlet/resources/xml.xsd", true);
        URL webservice11xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/j2ee_web_services_client_1_1.xsd", true);
        URL webservice12xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/javaee_web_services_client_1_2.xsd", true);
        URL datatypesdtd = Loader.getResource(Servlet.class, "javax/servlet/resources/datatypes.dtd", true);
        URL jsp20xsd = null;
        URL jsp21xsd = null;
        try {
            Class jsp_page = Loader.loadClass(WebXmlConfiguration.class, "javax.servlet.jsp.JspPage");
            jsp20xsd = jsp_page.getResource("/javax/servlet/resources/jsp_2_0.xsd");
            jsp21xsd = jsp_page.getResource("/javax/servlet/resources/jsp_2_1.xsd");
        }
        catch (Exception e) {
            Log.ignore(e);
        }
        finally {
            if (jsp20xsd == null) {
                jsp20xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/jsp_2_0.xsd", true);
            }
            if (jsp21xsd == null) {
                jsp21xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/jsp_2_1.xsd", true);
            }
        }
        WebXmlProcessor.redirect(xmlParser, "web-app_2_2.dtd", dtd22);
        WebXmlProcessor.redirect(xmlParser, "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", dtd22);
        WebXmlProcessor.redirect(xmlParser, "web.dtd", dtd23);
        WebXmlProcessor.redirect(xmlParser, "web-app_2_3.dtd", dtd23);
        WebXmlProcessor.redirect(xmlParser, "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", dtd23);
        WebXmlProcessor.redirect(xmlParser, "XMLSchema.dtd", schemadtd);
        WebXmlProcessor.redirect(xmlParser, "http://www.w3.org/2001/XMLSchema.dtd", schemadtd);
        WebXmlProcessor.redirect(xmlParser, "-//W3C//DTD XMLSCHEMA 200102//EN", schemadtd);
        WebXmlProcessor.redirect(xmlParser, "jsp_2_0.xsd", jsp20xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/j2ee/jsp_2_0.xsd", jsp20xsd);
        WebXmlProcessor.redirect(xmlParser, "jsp_2_1.xsd", jsp21xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/jsp_2_1.xsd", jsp21xsd);
        WebXmlProcessor.redirect(xmlParser, "j2ee_1_4.xsd", j2ee14xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", j2ee14xsd);
        WebXmlProcessor.redirect(xmlParser, "web-app_2_4.xsd", webapp24xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", webapp24xsd);
        WebXmlProcessor.redirect(xmlParser, "web-app_2_5.xsd", webapp25xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", webapp25xsd);
        WebXmlProcessor.redirect(xmlParser, "web-app_3_0.xsd", webapp30xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd", webapp30xsd);
        WebXmlProcessor.redirect(xmlParser, "web-common_3_0.xsd", webcommon30xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-common_3_0.xsd", webcommon30xsd);
        WebXmlProcessor.redirect(xmlParser, "web-fragment_3_0.xsd", webfragment30xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-fragment_3_0.xsd", webfragment30xsd);
        WebXmlProcessor.redirect(xmlParser, "xml.xsd", xmlxsd);
        WebXmlProcessor.redirect(xmlParser, "http://www.w3.org/2001/xml.xsd", xmlxsd);
        WebXmlProcessor.redirect(xmlParser, "datatypes.dtd", datatypesdtd);
        WebXmlProcessor.redirect(xmlParser, "http://www.w3.org/2001/datatypes.dtd", datatypesdtd);
        WebXmlProcessor.redirect(xmlParser, "j2ee_web_services_client_1_1.xsd", webservice11xsd);
        WebXmlProcessor.redirect(xmlParser, "http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", webservice11xsd);
        WebXmlProcessor.redirect(xmlParser, "javaee_web_services_client_1_2.xsd", webservice12xsd);
        WebXmlProcessor.redirect(xmlParser, "http://www.ibm.com/webservices/xsd/javaee_web_services_client_1_2.xsd", webservice12xsd);
        return xmlParser;
    }

    protected static void redirect(XmlParser parser, String resource, URL source) {
        if (source != null) {
            parser.redirectEntity(resource, source);
        }
    }

    public WebXmlProcessor(WebAppContext context) throws ClassNotFoundException {
        this._context = context;
        this._xmlParser = WebXmlProcessor.webXmlParser();
    }

    public void parseDefaults(Resource webDefaults) throws Exception {
        this._webDefaultsRoot = new Descriptor(webDefaults);
        this._webDefaultsRoot.parse();
    }

    public void parseWebXml(Resource webXml) throws Exception {
        this._webXmlRoot = new Descriptor(webXml);
        this._webXmlRoot.parse();
        this._webXmlRoot.processClassNames();
        this._context.setAttribute(METADATA_COMPLETE, this._webXmlRoot.isMetaDataComplete());
        this._context.setAttribute(WEBXML_VERSION, this._webXmlRoot.getVersion());
        this._context.setAttribute(WEBXML_CLASSNAMES, this._webXmlRoot.getClassNames());
    }

    public void parseFragment(Resource fragment) throws Exception {
        if (this._webXmlRoot.isMetaDataComplete()) {
            return;
        }
        Descriptor frag = new Descriptor(fragment);
        frag.parse();
        this._webFragmentRoots.add(frag);
    }

    public void parseOverride(Resource override) throws Exception {
        this._xmlParser.setValidating(false);
        this._webOverrideRoot = new Descriptor(override);
        this._webOverrideRoot.parse();
    }

    public void processDefaults() throws Exception {
        this._webDefaultsRoot.process();
        this._defaultWelcomeFileList = this._context.getWelcomeFiles() != null;
    }

    public void processWebXml() throws Exception {
        if (this._webXmlRoot != null) {
            this._webXmlRoot.process();
        }
    }

    public void processFragments() throws Exception {
        for (Descriptor frag : this._webFragmentRoots) {
            frag.process();
        }
    }

    public void processOverride() throws Exception {
        this._webOverrideRoot.process();
    }

    public Descriptor getWebXml() {
        return this._webXmlRoot;
    }

    public Descriptor getOverrideWeb() {
        return this._webOverrideRoot;
    }

    public Descriptor getWebDefault() {
        return this._webDefaultsRoot;
    }

    public List<Descriptor> getFragments() {
        return this._webFragmentRoots;
    }

    public void process(XmlParser.Node config) throws Exception {
        this._servletHandler = this._context.getServletHandler();
        this._securityHandler = this._context.getSecurityHandler();
        this._filters = LazyList.array2List(this._servletHandler.getFilters());
        this._filterMappings = LazyList.array2List(this._servletHandler.getFilterMappings());
        this._servlets = LazyList.array2List(this._servletHandler.getServlets());
        this._servletMappings = LazyList.array2List(this._servletHandler.getServletMappings());
        this._listeners = LazyList.array2List(this._context.getEventListeners());
        this._welcomeFiles = LazyList.array2List(this._context.getWelcomeFiles());
        if (this._securityHandler instanceof ConstraintAware) {
            this._constraintMappings = LazyList.array2List(((ConstraintAware)((Object)this._securityHandler)).getConstraintMappings());
            if (((ConstraintAware)((Object)this._securityHandler)).getRoles() != null) {
                this._roles.addAll(((ConstraintAware)((Object)this._securityHandler)).getRoles());
            }
        }
        this._errorPages = this._context.getErrorHandler() instanceof ErrorPageErrorHandler ? ((ErrorPageErrorHandler)this._context.getErrorHandler()).getErrorPages() : null;
        Iterator iter = config.iterator();
        XmlParser.Node node = null;
        while (iter.hasNext()) {
            try {
                Object o = iter.next();
                if (!(o instanceof XmlParser.Node)) continue;
                node = (XmlParser.Node)o;
                String name = node.getTag();
                this.initWebXmlElement(name, node);
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                Log.warn("Configuration problem at " + node, e);
                throw new UnavailableException("Configuration problem");
            }
        }
        this._servletHandler.setFilters((FilterHolder[])LazyList.toArray(this._filters, FilterHolder.class));
        this._servletHandler.setFilterMappings((FilterMapping[])LazyList.toArray(this._filterMappings, FilterMapping.class));
        this._servletHandler.setServlets((ServletHolder[])LazyList.toArray(this._servlets, ServletHolder.class));
        this._servletHandler.setServletMappings((ServletMapping[])LazyList.toArray(this._servletMappings, ServletMapping.class));
        this._context.setEventListeners((EventListener[])LazyList.toArray(this._listeners, EventListener.class));
        this._context.setWelcomeFiles((String[])LazyList.toArray(this._welcomeFiles, String.class));
        if (this._securityHandler instanceof ConstraintAware) {
            ((ConstraintAware)((Object)this._securityHandler)).setConstraintMappings((ConstraintMapping[])LazyList.toArray(this._constraintMappings, ConstraintMapping.class), this._roles);
        }
        if (this._errorPages != null && this._context.getErrorHandler() instanceof ErrorPageErrorHandler) {
            ((ErrorPageErrorHandler)this._context.getErrorHandler()).setErrorPages(this._errorPages);
        }
    }

    protected void initWebXmlElement(String element, XmlParser.Node node) throws Exception {
        if ("display-name".equals(element)) {
            this.initDisplayName(node);
        } else if (!"description".equals(element)) {
            if ("context-param".equals(element)) {
                this.initContextParam(node);
            } else if ("servlet".equals(element)) {
                this.initServlet(node);
            } else if ("servlet-mapping".equals(element)) {
                this.initServletMapping(node);
            } else if ("session-config".equals(element)) {
                this.initSessionConfig(node);
            } else if ("mime-mapping".equals(element)) {
                this.initMimeConfig(node);
            } else if ("welcome-file-list".equals(element)) {
                this.initWelcomeFileList(node);
            } else if ("locale-encoding-mapping-list".equals(element)) {
                this.initLocaleEncodingList(node);
            } else if ("error-page".equals(element)) {
                this.initErrorPage(node);
            } else if ("taglib".equals(element)) {
                this.initTagLib(node);
            } else if ("jsp-config".equals(element)) {
                this.initJspConfig(node);
            } else if ("resource-ref".equals(element)) {
                if (Log.isDebugEnabled()) {
                    Log.debug("No implementation: " + node);
                }
            } else if ("security-constraint".equals(element)) {
                this.initSecurityConstraint(node);
            } else if ("login-config".equals(element)) {
                this.initLoginConfig(node);
            } else if ("security-role".equals(element)) {
                this.initSecurityRole(node);
            } else if ("filter".equals(element)) {
                this.initFilter(node);
            } else if ("filter-mapping".equals(element)) {
                this.initFilterMapping(node);
            } else if ("listener".equals(element)) {
                this.initListener(node);
            } else if ("distributable".equals(element)) {
                this.initDistributable(node);
            } else if (!"web-fragment".equals(element) && Log.isDebugEnabled()) {
                Log.debug("Element {} not handled in {}", element, this);
                Log.debug(node.toString());
            }
        }
    }

    protected void initDisplayName(XmlParser.Node node) {
        this._context.setDisplayName(node.toString(false, true));
    }

    protected void initContextParam(XmlParser.Node node) {
        String name = node.getString("param-name", false, true);
        String value = node.getString("param-value", false, true);
        if (Log.isDebugEnabled()) {
            Log.debug("ContextParam: " + name + "=" + value);
        }
        this._context.getInitParams().put(name, value);
    }

    protected void initFilter(XmlParser.Node node) {
        String filter_class;
        String name = node.getString("filter-name", false, true);
        FilterHolder holder = this._servletHandler.getFilter(name);
        if (holder == null) {
            holder = this._servletHandler.newFilterHolder();
            holder.setName(name);
            this._filters = LazyList.add(this._filters, holder);
        }
        if ((filter_class = node.getString("filter-class", false, true)) != null) {
            holder.setClassName(filter_class);
        }
        Iterator iter = node.iterator("init-param");
        while (iter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            holder.setInitParameter(pname, pvalue);
        }
        String async = node.getString("async-supported", false, true);
        if (async != null) {
            holder.setAsyncSupported(async.length() == 0 || Boolean.valueOf(async) != false);
        }
        String timeout = node.getString("async-timeout", false, true);
    }

    protected void initFilterMapping(XmlParser.Node node) {
        String filter_name = node.getString("filter-name", false, true);
        FilterMapping mapping = new FilterMapping();
        mapping.setFilterName(filter_name);
        ArrayList<String> paths = new ArrayList<String>();
        Iterator iter = node.iterator("url-pattern");
        while (iter.hasNext()) {
            String p = ((XmlParser.Node)iter.next()).toString(false, true);
            p = this.normalizePattern(p);
            paths.add(p);
        }
        mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
        ArrayList<String> names = new ArrayList<String>();
        iter = node.iterator("servlet-name");
        while (iter.hasNext()) {
            String n = ((XmlParser.Node)iter.next()).toString(false, true);
            names.add(n);
        }
        mapping.setServletNames(names.toArray(new String[names.size()]));
        int dispatcher = 0;
        iter = node.iterator("dispatcher");
        while (iter.hasNext()) {
            String d = ((XmlParser.Node)iter.next()).toString(false, true);
            dispatcher |= FilterMapping.dispatch(d);
        }
        mapping.setDispatches(dispatcher);
        this._filterMappings = LazyList.add(this._filterMappings, mapping);
    }

    protected String normalizePattern(String p) {
        if (p != null && p.length() > 0 && !p.startsWith("/") && !p.startsWith("*")) {
            return "/" + p;
        }
        return p;
    }

    protected void initServlet(XmlParser.Node node) {
        String async;
        String roleName;
        XmlParser.Node startup;
        String jsp_file;
        String id = node.getAttribute("id");
        String servlet_name = node.getString("servlet-name", false, true);
        ServletHolder holder = this._servletHandler.getServlet(servlet_name);
        if (holder == null) {
            holder = this._servletHandler.newServletHolder();
            holder.setName(servlet_name);
            this._servlets = LazyList.add(this._servlets, holder);
        }
        Iterator iParamsIter = node.iterator("init-param");
        while (iParamsIter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iParamsIter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            holder.setInitParameter(pname, pvalue);
        }
        String servlet_class = node.getString("servlet-class", false, true);
        if (id != null && id.equals("jsp")) {
            this._jspServletName = servlet_name;
            this._jspServletClass = servlet_class;
            try {
                Loader.loadClass(this.getClass(), servlet_class);
                this._hasJSP = true;
            }
            catch (ClassNotFoundException e) {
                Log.info("NO JSP Support for {}, did not find {}", this._context.getContextPath(), servlet_class);
                this._hasJSP = false;
                servlet_class = "org.eclipse.jetty.servlet.NoJspServlet";
                this._jspServletClass = "org.eclipse.jetty.servlet.NoJspServlet";
            }
            try {
                Class logFactory = Loader.loadClass(this.getClass(), "org.eclipse.jetty.jsp.JettyLog");
                Method init = logFactory.getMethod("init", new Class[0]);
                Log.debug("Init JSP loggging " + init);
                init.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                Log.warn(e.toString());
                Log.ignore(e);
            }
            if (holder.getInitParameter("scratchdir") == null) {
                File tmp = this._context.getTempDirectory();
                File scratch = new File(tmp, "jsp");
                if (!scratch.exists()) {
                    scratch.mkdir();
                }
                holder.setInitParameter("scratchdir", scratch.getAbsolutePath());
                if ("?".equals(holder.getInitParameter("classpath"))) {
                    String classpath = this._context.getClassPath();
                    Log.debug("classpath=" + classpath);
                    if (classpath != null) {
                        holder.setInitParameter("classpath", classpath);
                    }
                }
            }
        }
        if (servlet_class != null) {
            holder.setClassName(servlet_class);
        }
        if ((jsp_file = node.getString("jsp-file", false, true)) != null) {
            holder.setForcedPath(jsp_file);
            holder.setClassName(this._jspServletClass);
        }
        if ((startup = node.get("load-on-startup")) != null) {
            String s = startup.toString(false, true).toLowerCase();
            if (s.startsWith("t")) {
                Log.warn("Deprecated boolean load-on-startup.  Please use integer");
                holder.setInitOrder(1);
            } else {
                int order = 0;
                try {
                    if (s != null && s.trim().length() > 0) {
                        order = Integer.parseInt(s);
                    }
                }
                catch (Exception e) {
                    Log.warn("Cannot parse load-on-startup " + s + ". Please use integer");
                    Log.ignore(e);
                }
                holder.setInitOrder(order);
            }
        }
        Iterator sRefsIter = node.iterator("security-role-ref");
        while (sRefsIter.hasNext()) {
            XmlParser.Node securityRef = (XmlParser.Node)sRefsIter.next();
            roleName = securityRef.getString("role-name", false, true);
            String roleLink = securityRef.getString("role-link", false, true);
            if (roleName != null && roleName.length() > 0 && roleLink != null && roleLink.length() > 0) {
                if (Log.isDebugEnabled()) {
                    Log.debug("link role " + roleName + " to " + roleLink + " for " + this);
                }
                holder.setUserRoleLink(roleName, roleLink);
                continue;
            }
            Log.warn("Ignored invalid security-role-ref element: servlet-name=" + holder.getName() + ", " + securityRef);
        }
        XmlParser.Node run_as = node.get("run-as");
        if (run_as != null && (roleName = run_as.getString("role-name", false, true)) != null) {
            holder.setRunAsRole(roleName);
        }
        if ((async = node.getString("async-supported", false, true)) != null) {
            holder.setAsyncSupported(async.length() == 0 || Boolean.valueOf(async) != false);
        }
        String timeout = node.getString("async-timeout", false, true);
    }

    protected void initServletMapping(XmlParser.Node node) {
        String servlet_name = node.getString("servlet-name", false, true);
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName(servlet_name);
        ArrayList<String> paths = new ArrayList<String>();
        Iterator iter = node.iterator("url-pattern");
        while (iter.hasNext()) {
            String p = ((XmlParser.Node)iter.next()).toString(false, true);
            p = this.normalizePattern(p);
            paths.add(p);
        }
        mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
        this._servletMappings = LazyList.add(this._servletMappings, mapping);
    }

    protected void initListener(XmlParser.Node node) {
        String className = node.getString("listener-class", false, true);
        Object listener = null;
        try {
            Class<?> listenerClass = this._context.loadClass(className);
            listener = this.newListenerInstance(listenerClass);
            if (!(listener instanceof EventListener)) {
                Log.warn("Not an EventListener: " + listener);
                return;
            }
            this._listeners = LazyList.add(this._listeners, listener);
        }
        catch (Exception e) {
            Log.warn("Could not instantiate listener " + className, e);
            return;
        }
    }

    protected Object newListenerInstance(Class clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    protected void initDistributable(XmlParser.Node node) {
        if (!this._context.isDistributable()) {
            this._context.setDistributable(true);
        }
    }

    protected void initSessionConfig(XmlParser.Node node) {
        XmlParser.Node tNode = node.get("session-timeout");
        if (tNode != null) {
            int timeout = Integer.parseInt(tNode.toString(false, true));
            this._context.getSessionHandler().getSessionManager().setMaxInactiveInterval(timeout * 60);
        }
    }

    protected void initMimeConfig(XmlParser.Node node) {
        String extension = node.getString("extension", false, true);
        if (extension != null && extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        String mimeType = node.getString("mime-type", false, true);
        this._context.getMimeTypes().addMimeMapping(extension, mimeType);
    }

    protected void initWelcomeFileList(XmlParser.Node node) {
        if (this._defaultWelcomeFileList) {
            this._welcomeFiles = null;
        }
        this._defaultWelcomeFileList = false;
        Iterator iter = node.iterator("welcome-file");
        while (iter.hasNext()) {
            XmlParser.Node indexNode = (XmlParser.Node)iter.next();
            String welcome = indexNode.toString(false, true);
            this._welcomeFiles = LazyList.add(this._welcomeFiles, welcome);
        }
    }

    protected void initLocaleEncodingList(XmlParser.Node node) {
        Iterator iter = node.iterator("locale-encoding-mapping");
        while (iter.hasNext()) {
            XmlParser.Node mapping = (XmlParser.Node)iter.next();
            String locale = mapping.getString("locale", false, true);
            String encoding = mapping.getString("encoding", false, true);
            this._context.addLocaleEncoding(locale, encoding);
        }
    }

    protected void initErrorPage(XmlParser.Node node) {
        String error = node.getString("error-code", false, true);
        if (error == null || error.length() == 0) {
            error = node.getString("exception-type", false, true);
        }
        String location = node.getString("location", false, true);
        if (this._errorPages == null) {
            this._errorPages = new HashMap();
        }
        this._errorPages.put(error, location);
    }

    protected void initTagLib(XmlParser.Node node) {
        String uri = node.getString("taglib-uri", false, true);
        String location = node.getString("taglib-location", false, true);
        this._context.setResourceAlias(uri, location);
    }

    protected void initJspConfig(XmlParser.Node node) {
        String jspName;
        for (int i = 0; i < node.size(); ++i) {
            Object o = node.get(i);
            if (!(o instanceof XmlParser.Node) || !"taglib".equals(((XmlParser.Node)o).getTag())) continue;
            this.initTagLib((XmlParser.Node)o);
        }
        Iterator iter = node.iterator("jsp-property-group");
        Object paths = null;
        while (iter.hasNext()) {
            XmlParser.Node group = (XmlParser.Node)iter.next();
            Iterator iter2 = group.iterator("url-pattern");
            while (iter2.hasNext()) {
                String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                url = this.normalizePattern(url);
                paths = LazyList.add(paths, url);
            }
        }
        if (LazyList.size(paths) > 0 && (jspName = this.getJSPServletName()) != null) {
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(jspName);
            mapping.setPathSpecs(LazyList.toStringArray(paths));
            this._servletMappings = LazyList.add(this._servletMappings, mapping);
        }
    }

    protected void initSecurityConstraint(XmlParser.Node node) {
        Constraint scBase = new Constraint();
        try {
            XmlParser.Node data;
            XmlParser.Node auths = node.get("auth-constraint");
            if (auths != null) {
                scBase.setAuthenticate(true);
                Iterator iter = auths.iterator("role-name");
                Object roles = null;
                while (iter.hasNext()) {
                    String role = ((XmlParser.Node)iter.next()).toString(false, true);
                    roles = LazyList.add(roles, role);
                }
                scBase.setRoles(LazyList.toStringArray(roles));
            }
            if ((data = node.get("user-data-constraint")) != null) {
                String guarantee = (data = data.get("transport-guarantee")).toString(false, true).toUpperCase();
                if (guarantee == null || guarantee.length() == 0 || "NONE".equals(guarantee)) {
                    scBase.setDataConstraint(0);
                } else if ("INTEGRAL".equals(guarantee)) {
                    scBase.setDataConstraint(1);
                } else if ("CONFIDENTIAL".equals(guarantee)) {
                    scBase.setDataConstraint(2);
                } else {
                    Log.warn("Unknown user-data-constraint:" + guarantee);
                    scBase.setDataConstraint(2);
                }
            }
            Iterator iter = node.iterator("web-resource-collection");
            while (iter.hasNext()) {
                XmlParser.Node collection = (XmlParser.Node)iter.next();
                String name = collection.getString("web-resource-name", false, true);
                Constraint sc = (Constraint)scBase.clone();
                sc.setName(name);
                Iterator iter2 = collection.iterator("url-pattern");
                while (iter2.hasNext()) {
                    String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                    url = this.normalizePattern(url);
                    Iterator iter3 = collection.iterator("http-method");
                    if (iter3.hasNext()) {
                        while (iter3.hasNext()) {
                            String method = ((XmlParser.Node)iter3.next()).toString(false, true);
                            ConstraintMapping mapping = new ConstraintMapping();
                            mapping.setMethod(method);
                            mapping.setPathSpec(url);
                            mapping.setConstraint(sc);
                            this._constraintMappings = LazyList.add(this._constraintMappings, mapping);
                        }
                        continue;
                    }
                    ConstraintMapping mapping = new ConstraintMapping();
                    mapping.setPathSpec(url);
                    mapping.setConstraint(sc);
                    this._constraintMappings = LazyList.add(this._constraintMappings, mapping);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            Log.warn(e);
        }
    }

    protected void initLoginConfig(XmlParser.Node node) throws Exception {
        XmlParser.Node method = node.get("auth-method");
        if (method != null) {
            XmlParser.Node name = node.get("realm-name");
            this._securityHandler.setRealmName(name == null ? "default" : name.toString(false, true));
            this._securityHandler.setAuthMethod(method.toString(false, true));
            if ("FORM".equals(this._securityHandler.getAuthMethod())) {
                XmlParser.Node formConfig = node.get("form-login-config");
                if (formConfig != null) {
                    String loginPageName = null;
                    XmlParser.Node loginPage = formConfig.get("form-login-page");
                    if (loginPage != null) {
                        loginPageName = loginPage.toString(false, true);
                    }
                    String errorPageName = null;
                    XmlParser.Node errorPage = formConfig.get("form-error-page");
                    if (errorPage != null) {
                        errorPageName = errorPage.toString(false, true);
                    }
                    this._securityHandler.setInitParameter("org.eclipse.jetty.security.form_login_page", loginPageName);
                    this._securityHandler.setInitParameter("org.eclipse.jetty.security.form_error_page", errorPageName);
                } else {
                    throw new IllegalArgumentException("!form-login-config");
                }
            }
        }
    }

    protected void initSecurityRole(XmlParser.Node node) {
        XmlParser.Node roleNode = node.get("role-name");
        String role = roleNode.toString(false, true);
        this._roles.add(role);
    }

    protected String getJSPServletName() {
        PathMap.Entry entry;
        if (this._jspServletName == null && (entry = this._context.getServletHandler().getHolderEntry("test.jsp")) != null) {
            ServletHolder holder = (ServletHolder)entry.getValue();
            this._jspServletName = holder.getName();
        }
        return this._jspServletName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Descriptor {
        protected Resource _xml;
        protected XmlParser.Node _root;
        protected boolean _metadataComplete;
        protected boolean _hasOrdering;
        protected int _version;
        protected ArrayList<String> _classNames;

        public Descriptor(Resource xml) {
            this._xml = xml;
        }

        public void parse() throws Exception {
            if (this._root == null) {
                this._root = WebXmlProcessor.this._xmlParser.parse(this._xml.getURL().toString());
                this.processVersion();
                this.processOrdering();
            }
        }

        public boolean isMetaDataComplete() {
            return this._metadataComplete;
        }

        public XmlParser.Node getRoot() {
            return this._root;
        }

        public int getVersion() {
            return this._version;
        }

        public Resource getResource() {
            return this._xml;
        }

        public void process() throws Exception {
            WebXmlProcessor.this.process(this._root);
        }

        private void processVersion() {
            String version = this._root.getAttribute("version", "DTD");
            if ("2.5".equals(version)) {
                this._version = 25;
            } else if ("2.4".equals(version)) {
                this._version = 24;
            } else if ("3.0".equals(version)) {
                this._version = 30;
            } else if ("DTD".equals(version)) {
                this._version = 23;
                String dtd = WebXmlProcessor.this._xmlParser.getDTD();
                if (dtd != null && dtd.indexOf("web-app_2_2") >= 0) {
                    this._version = 22;
                }
            }
            this._metadataComplete = this._version < 25 ? true : Boolean.valueOf(this._root.getAttribute("metadata-complete", "false"));
            Log.debug(this._xml.toString() + ": Calculated metadatacomplete = " + this._metadataComplete + " with version=" + version);
        }

        private void processOrdering() {
        }

        private void processClassNames() {
            this._classNames = new ArrayList();
            for (Object o : this._root) {
                String className;
                if (!(o instanceof XmlParser.Node)) continue;
                XmlParser.Node node = (XmlParser.Node)o;
                String name = node.getTag();
                if ("servlet".equals(name)) {
                    className = node.getString("servlet-class", false, true);
                    if (className == null) continue;
                    this._classNames.add(className);
                    continue;
                }
                if ("filter".equals(name)) {
                    className = node.getString("filter-class", false, true);
                    if (className == null) continue;
                    this._classNames.add(className);
                    continue;
                }
                if (!"listener".equals(name) || (className = node.getString("listener-class", false, true)) == null) continue;
                this._classNames.add(className);
            }
        }

        public ArrayList<String> getClassNames() {
            return this._classNames;
        }
    }
}

