/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.properties;

import java.lang.reflect.Field;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class MarkerProperties
implements IPropertySource {
    private static final AttributeDescriptor[] NO_DESCRIPTORS = new AttributeDescriptor[0];
    private final IMarker fMarker;
    private AttributeDescriptor[] fPropertyDescriptors;

    public MarkerProperties(IMarker marker) {
        this.fMarker = marker;
    }

    public AttributeDescriptor[] getPropertyDescriptors() {
        if (this.fPropertyDescriptors != null) {
            return this.fPropertyDescriptors;
        }
        Map attributes = null;
        boolean isJavaMarker = false;
        try {
            Map uncheckedAttributes;
            attributes = uncheckedAttributes = this.fMarker.getAttributes();
            isJavaMarker = "org.eclipse.jdt.core.problem".equals(this.fMarker.getType());
        }
        catch (CoreException coreException) {}
        if (attributes == null) {
            this.fPropertyDescriptors = NO_DESCRIPTORS;
        } else {
            String time;
            String type;
            this.fPropertyDescriptors = new AttributeDescriptor[attributes.size() + 4];
            int i = 0;
            for (Map.Entry entry : attributes.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                AttributeDescriptor propertyDescriptor = isJavaMarker && "id".equals(key) ? new ProblemIdAttributeDescriptor(key, value) : new AttributeDescriptor(key, value);
                propertyDescriptor.setAlwaysIncompatible(true);
                propertyDescriptor.setCategory("Attributes");
                this.fPropertyDescriptors[i++] = propertyDescriptor;
            }
            MarkerPropertyDescriptor propertyDescriptor = new MarkerPropertyDescriptor("exists", this.fMarker.exists());
            propertyDescriptor.setAlwaysIncompatible(true);
            this.fPropertyDescriptors[i++] = propertyDescriptor;
            try {
                type = this.fMarker.getType();
            }
            catch (CoreException e) {
                type = e.getLocalizedMessage();
            }
            propertyDescriptor = new MarkerPropertyDescriptor("type", type);
            propertyDescriptor.setAlwaysIncompatible(true);
            this.fPropertyDescriptors[i++] = propertyDescriptor;
            try {
                time = DateFormat.getDateTimeInstance().format(new Date(this.fMarker.getCreationTime()));
            }
            catch (CoreException e) {
                time = e.getLocalizedMessage();
            }
            propertyDescriptor = new MarkerPropertyDescriptor("creationTime", time);
            propertyDescriptor.setAlwaysIncompatible(true);
            this.fPropertyDescriptors[i++] = propertyDescriptor;
            propertyDescriptor = new MarkerPropertyDescriptor("markerId", this.fMarker.getId());
            propertyDescriptor.setAlwaysIncompatible(true);
            this.fPropertyDescriptors[i++] = propertyDescriptor;
        }
        return this.fPropertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        AttributeDescriptor[] propertyDescriptors;
        AttributeDescriptor[] attributeDescriptorArray = propertyDescriptors = this.getPropertyDescriptors();
        int n = propertyDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDescriptor descriptor = attributeDescriptorArray[n2];
            if (descriptor.getId().equals(id)) {
                return descriptor.getValue();
            }
            ++n2;
        }
        return null;
    }

    public void setPropertyValue(Object name, Object value) {
    }

    public Object getEditableValue() {
        return this;
    }

    public boolean isPropertySet(Object property) {
        return false;
    }

    public void resetPropertyValue(Object property) {
    }

    private static class AttributeDescriptor
    extends PropertyDescriptor {
        private final Object fValue;

        public AttributeDescriptor(String name, Object value) {
            this("org.eclipse.jdt.jeview.IMarker." + name, name, value);
        }

        protected AttributeDescriptor(String key, String name, Object value) {
            super((Object)key, name);
            this.fValue = value;
        }

        public Object getValue() {
            return this.fValue;
        }
    }

    private static class MarkerPropertyDescriptor
    extends AttributeDescriptor {
        public MarkerPropertyDescriptor(String key, Object value) {
            super("org.eclipse.jdt.jeview.IMarker.property." + key, key, value);
        }
    }

    private static class ProblemIdAttributeDescriptor
    extends AttributeDescriptor {
        public ProblemIdAttributeDescriptor(String key, Object value) {
            super(key, value);
        }

        @Override
        public Object getValue() {
            return this.getErrorLabel();
        }

        private String getErrorLabel() {
            int id = (Integer)super.getValue();
            StringBuffer buf = new StringBuffer(ProblemIdAttributeDescriptor.getConstantName(id)).append(" = ");
            if ((id & 0x1000000) != 0) {
                buf.append("TypeRelated + ");
            }
            if ((id & 0x2000000) != 0) {
                buf.append("FieldRelated + ");
            }
            if ((id & 0x8000000) != 0) {
                buf.append("ConstructorRelated + ");
            }
            if ((id & 0x4000000) != 0) {
                buf.append("MethodRelated + ");
            }
            if ((id & 0x10000000) != 0) {
                buf.append("ImportRelated + ");
            }
            if ((id & 0x20000000) != 0) {
                buf.append("Internal + ");
            }
            if ((id & 0x40000000) != 0) {
                buf.append("Syntax + ");
            }
            if ((id & Integer.MIN_VALUE) != 0) {
                buf.append("Javadoc + ");
            }
            buf.append(id & 0x1FFFFF);
            buf.append(" = 0x").append(Integer.toHexString(id)).append(" = ").append(id);
            return buf.toString();
        }

        private static String getConstantName(int id) {
            Field[] fields;
            Field[] fieldArray = fields = IProblem.class.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                try {
                    if (f.getType() == Integer.TYPE && f.getInt(f) == id) {
                        return "IProblem." + f.getName();
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {}
                ++n2;
            }
            return "<UNKNOWN CONSTANT>";
        }
    }
}

