/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.ui.internal.preferences;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;
import org.eclipse.jdt.apt.ui.internal.preferences.Messages;
import org.eclipse.jdt.apt.ui.internal.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AdvancedFactoryPathOptionsDialog
extends StatusDialog {
    private static final int LIST_WIDTH = 70;
    private static final int LIST_HEIGHT = 10;
    private final FactoryContainer _fc;
    private final FactoryPath.Attributes _attr;
    private SelectionButtonDialogField _batchModeField;
    private ListViewer _contentsField;

    public AdvancedFactoryPathOptionsDialog(Shell parent, FactoryContainer fc, FactoryPath.Attributes attr) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this._fc = fc;
        this._attr = attr;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.AdvancedFactoryPathOptionsDialog_advancedOptions);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.jdt.apt.ui.advanced_factory_path_options_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dlgArea = (Composite)super.createDialogArea(parent);
        FieldAdapter adapter = new FieldAdapter();
        this._batchModeField = new SelectionButtonDialogField(32);
        this._batchModeField.setSelection(this._attr.runInBatchMode());
        this._batchModeField.setLabelText(Messages.AdvancedFactoryPathOptionsDialog_batchMode);
        this._batchModeField.setDialogFieldListener((IDialogFieldListener)adapter);
        this._batchModeField.doFillIntoGrid(dlgArea, 2);
        boolean isPlugin = this._fc.getType() == FactoryContainer.FactoryType.PLUGIN;
        this._batchModeField.setEnabled(!isPlugin);
        DialogField.createEmptySpace((Composite)dlgArea, (int)1);
        Label description = new Label(dlgArea, 64);
        description.setText(Messages.AdvancedFactoryPathOptionsDialog_label_processorsInThisContainer);
        GridData gdLabel = new GridData(256);
        gdLabel.horizontalSpan = 2;
        description.setLayoutData((Object)gdLabel);
        this._contentsField = new ListViewer(dlgArea, 2820);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.widthHint = this.convertWidthInCharsToPixels(70);
        this._contentsField.getList().setLayoutData((Object)data);
        this._contentsField.getList().setFont(parent.getFont());
        try {
            for (Map.Entry entry : this._fc.getFactoryNames().entrySet()) {
                String name = (String)entry.getKey();
                this._contentsField.add((Object)name);
            }
        }
        catch (IOException e) {
            String message = "Unable to load factory names from container [" + this._fc.getId() + "]";
            ExceptionHandler.log(e, message);
        }
        this._contentsField.setSelection(null, false);
        AdvancedFactoryPathOptionsDialog.applyDialogFont((Control)dlgArea);
        return dlgArea;
    }

    public FactoryPath.Attributes getResult() {
        boolean batchMode = this._batchModeField.isSelected();
        return new FactoryPath.Attributes(this._attr.isEnabled(), batchMode);
    }

    private static class FieldAdapter
    implements IDialogFieldListener {
        private FieldAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
        }
    }
}

