/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.credential;

import hudson.scm.SubversionSCM;
import hudson.util.Scrambler;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;

public class SslClientCertificateCredential
extends SubversionSCM.DescriptorImpl.Credential {
    private final Secret certificate;
    private final String password;

    public SslClientCertificateCredential(File certificate, String password) throws IOException {
        this.password = Scrambler.scramble((String)password);
        this.certificate = Secret.fromString((String)new String(Base64.encodeBase64((byte[])FileUtils.readFileToByteArray((File)certificate))));
    }

    public SVNAuthentication createSVNAuthentication(String kind) {
        if (kind.equals("svn.ssl.client-passphrase")) {
            return new SVNSSLAuthentication(Base64.decodeBase64((String)this.certificate.getPlainText()), Scrambler.descramble((String)this.password), false);
        }
        return null;
    }
}

