/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.example.protocolgateway;

import io.smallrye.config.ConfigMapping;
import io.vertx.core.Vertx;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.eclipse.hono.client.amqp.config.ClientConfigProperties;
import org.eclipse.hono.client.amqp.config.ClientOptions;
import org.eclipse.hono.client.amqp.connection.HonoConnection;
import org.eclipse.hono.client.device.amqp.AmqpAdapterClient;
import org.eclipse.hono.config.ServerOptions;

@ApplicationScoped
public class ConfigurationProducer {
    @Inject
    Vertx vertx;
    @Inject
    @ConfigMapping(prefix="gateway.tcp")
    ServerOptions serverOptions;
    @Inject
    @ConfigMapping(prefix="gateway.amqp")
    ClientOptions amqpAdapterClientOptions;

    @Produces
    @Singleton
    @Named(value="TENANT_ID")
    String tenantId() {
        return this.amqpAdapterClientOptions.authenticatingClientOptions().username().map(username -> username.substring(username.indexOf("@") + 1)).orElse("DEFAULT_TENANT");
    }

    @Produces
    @Dependent
    HonoConnection amqpAdapterConnection() {
        ClientConfigProperties props = new ClientConfigProperties(this.amqpAdapterClientOptions);
        return HonoConnection.newConnection((Vertx)this.vertx, (ClientConfigProperties)props);
    }

    @Produces
    @Dependent
    AmqpAdapterClient amqpAdapterClient(HonoConnection amqpAdapterConnection) {
        return AmqpAdapterClient.create((HonoConnection)amqpAdapterConnection);
    }
}

