/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter.impl.kafka;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.buffer.Buffer;
import io.vertx.kafka.client.consumer.KafkaConsumerRecord;
import java.util.Objects;
import org.eclipse.hono.adapter.client.command.CommandContext;
import org.eclipse.hono.adapter.client.command.InternalCommandSender;
import org.eclipse.hono.adapter.client.command.kafka.KafkaBasedCommand;
import org.eclipse.hono.adapter.client.command.kafka.KafkaBasedCommandContext;
import org.eclipse.hono.adapter.client.command.kafka.KafkaBasedInternalCommandSender;
import org.eclipse.hono.adapter.client.registry.TenantClient;
import org.eclipse.hono.client.impl.CommandConsumer;
import org.eclipse.hono.client.kafka.tracing.KafkaTracingHelper;
import org.eclipse.hono.commandrouter.CommandTargetMapper;
import org.eclipse.hono.commandrouter.impl.AbstractMappingAndDelegatingCommandHandler;

public class KafkaBasedMappingAndDelegatingCommandHandler
extends AbstractMappingAndDelegatingCommandHandler {
    private final Tracer tracer;

    public KafkaBasedMappingAndDelegatingCommandHandler(TenantClient tenantClient, CommandTargetMapper commandTargetMapper, KafkaBasedInternalCommandSender internalCommandSender, Tracer tracer) {
        super(tenantClient, commandTargetMapper, (InternalCommandSender)internalCommandSender);
        Objects.requireNonNull(tracer);
        this.tracer = tracer;
    }

    public void mapAndDelegateIncomingCommandMessage(KafkaConsumerRecord<String, Buffer> consumerRecord) {
        KafkaBasedCommand command;
        Objects.requireNonNull(consumerRecord);
        try {
            command = KafkaBasedCommand.from(consumerRecord);
        }
        catch (IllegalArgumentException exception) {
            this.log.debug("command record is invalid", (Throwable)exception);
            return;
        }
        SpanContext spanContext = KafkaTracingHelper.extractSpanContext((Tracer)this.tracer, consumerRecord);
        Span currentSpan = CommandConsumer.createSpan((String)"map and delegate command", (String)command.getTenant(), (String)command.getDeviceId(), null, (Tracer)this.tracer, (SpanContext)spanContext);
        KafkaTracingHelper.setRecordTags((Span)currentSpan, consumerRecord);
        KafkaBasedCommandContext commandContext = new KafkaBasedCommandContext(command, currentSpan);
        command.logToSpan(currentSpan);
        if (command.isValid()) {
            this.log.trace("received valid command record [{}]", (Object)command);
            this.mapAndDelegateIncomingCommand((CommandContext)commandContext);
        } else {
            this.log.debug("received invalid command record [{}]", (Object)command);
            commandContext.reject("malformed command message");
        }
    }
}

