/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.delegating;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.client.amqp.config.ClientConfigProperties;
import org.eclipse.hono.service.auth.AbstractHonoAuthenticationService;
import org.eclipse.hono.service.auth.SignatureSupportingConfigProperties;
import org.eclipse.hono.service.auth.delegating.AuthenticationServerClientOptions;

public class AuthenticationServerClientConfigProperties
extends ClientConfigProperties {
    private SignatureSupportingConfigProperties validation = new SignatureSupportingConfigProperties();
    private List<String> supportedSaslMechanisms = List.of("EXTERNAL", "PLAIN");
    private int jwksEndpointPort = 8088;
    private String jwksEndpointUri = "/validating-keys";
    private boolean jwksEndpointTlsEnabled = false;
    private Duration jwksPollingInterval = Duration.ofMinutes(5L);
    private boolean jwksSignatureAlgorithmRequired = false;

    public AuthenticationServerClientConfigProperties() {
    }

    public AuthenticationServerClientConfigProperties(AuthenticationServerClientOptions options) {
        super(options.clientOptions());
        this.setSupportedSaslMechanisms(List.copyOf(options.supportedSaslMechanisms()));
        this.validation = new SignatureSupportingConfigProperties(options.validation());
        this.jwksEndpointPort = options.jwksEndpointPort();
        this.jwksEndpointTlsEnabled = options.jwksEndpointTlsEnabled();
        this.jwksEndpointUri = options.jwksEndpointUri();
        this.jwksPollingInterval = options.jwksPollingInterval();
        this.jwksSignatureAlgorithmRequired = options.jwksSignatureAlgorithmRequired();
    }

    public final void setValidation(SignatureSupportingConfigProperties props) {
        this.validation = Objects.requireNonNull(props);
    }

    public final SignatureSupportingConfigProperties getValidation() {
        return this.validation;
    }

    public final List<String> getSupportedSaslMechanisms() {
        return this.supportedSaslMechanisms;
    }

    public final void setSupportedSaslMechanisms(List<String> supportedSaslMechanisms) {
        if (Objects.requireNonNull(supportedSaslMechanisms).stream().noneMatch(AbstractHonoAuthenticationService::isCompatibleSaslMechanism)) {
            throw new IllegalArgumentException("invalid list of SASL mechanisms");
        }
        this.supportedSaslMechanisms = supportedSaslMechanisms;
    }

    public final int getJwksEndpointPort() {
        return this.jwksEndpointPort;
    }

    public final void setJwksEndpointPort(int port) {
        if (!this.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port number");
        }
        this.jwksEndpointPort = port;
    }

    public final String getJwksEndpointUri() {
        return this.jwksEndpointUri;
    }

    public final void setJwksEndpointUri(String uri) {
        this.jwksEndpointUri = Objects.requireNonNull(uri);
    }

    public final boolean isJwksEndpointTlsEnabled() {
        return this.jwksEndpointTlsEnabled;
    }

    public final void setJwksEndpointTlsEnabled(boolean flag) {
        this.jwksEndpointTlsEnabled = flag;
    }

    public final Duration getJwksPollingInterval() {
        return this.jwksPollingInterval;
    }

    public final void setJwksPollingInterval(Duration interval) {
        Objects.requireNonNull(interval);
        if (interval.toSeconds() < 10L) {
            throw new IllegalArgumentException("polling interval must be at least 10 seconds");
        }
        this.jwksPollingInterval = interval;
    }

    public final boolean isJwksSignatureAlgorithmRequired() {
        return this.jwksSignatureAlgorithmRequired;
    }

    public final void setJwksSignatureAlgorithmRequired(boolean flag) {
        this.jwksSignatureAlgorithmRequired = flag;
    }
}

