/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import com.google.common.hash.Hashing;
import io.vertx.core.Vertx;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.crypto.SecretKey;
import org.eclipse.hono.config.KeyLoader;

abstract class JwtSupport {
    protected final Vertx vertx;
    private final Map<String, Key> signingKeys = new HashMap<String, Key>(5);
    private final Map<String, Key> validatingKeys = new HashMap<String, Key>(5);

    protected JwtSupport(Vertx vertx) {
        this.vertx = vertx;
    }

    protected static final byte[] getBytes(String secret) {
        return secret.getBytes(StandardCharsets.UTF_8);
    }

    private String createKeyId(byte[] encodedKey) {
        return Hashing.sha256().hashBytes(encodedKey).toString();
    }

    protected final String addSecretKey(SecretKey secretKey) {
        Objects.requireNonNull(secretKey);
        String id = this.createKeyId(secretKey.getEncoded());
        this.signingKeys.put(id, secretKey);
        this.validatingKeys.put(id, secretKey);
        return id;
    }

    protected final String addPrivateKey(String keyPath, String certPath) {
        Objects.requireNonNull(keyPath);
        Objects.requireNonNull(certPath);
        KeyLoader keys = KeyLoader.fromFiles((Vertx)this.vertx, (String)keyPath, (String)certPath);
        return this.addPrivateKey(keys.getPrivateKey(), keys.getPublicKey());
    }

    protected final String addPrivateKey(PrivateKey privateKey, PublicKey publicKey) {
        Objects.requireNonNull(privateKey);
        Objects.requireNonNull(publicKey);
        String keyId = this.createKeyId(publicKey.getEncoded());
        this.addPrivateKey(keyId, privateKey, publicKey);
        return keyId;
    }

    protected final void addPrivateKey(String keyId, PrivateKey privateKey, PublicKey publicKey) {
        Objects.requireNonNull(keyId);
        Objects.requireNonNull(privateKey);
        Objects.requireNonNull(publicKey);
        this.signingKeys.put(keyId, privateKey);
        this.validatingKeys.put(keyId, publicKey);
    }

    protected final void setPublicKey(String keyPath) {
        Objects.requireNonNull(keyPath);
        PublicKey publicKey = KeyLoader.fromFiles((Vertx)this.vertx, null, (String)keyPath).getPublicKey();
        if (publicKey == null) {
            throw new IllegalArgumentException("cannot load public key: " + keyPath);
        }
        this.setValidatingKeys(Map.of(this.createKeyId(publicKey.getEncoded()), publicKey));
    }

    protected final void setValidatingKeys(Map<String, Key> keys) {
        Objects.requireNonNull(keys);
        this.validatingKeys.clear();
        this.validatingKeys.putAll(keys);
    }

    protected final Key getValidatingKey() {
        if (this.validatingKeys.size() != 1) {
            throw new IllegalStateException("more than one validating key is registered");
        }
        return this.validatingKeys.values().iterator().next();
    }

    protected final Key getValidatingKey(String keyId) {
        Objects.requireNonNull(keyId);
        return this.validatingKeys.get(keyId);
    }

    protected final Set<Map.Entry<String, Key>> getValidatingKeys() {
        return Collections.unmodifiableSet(this.validatingKeys.entrySet());
    }

    public final boolean hasValidatingKey() {
        return !this.validatingKeys.isEmpty();
    }

    protected final Key getSigningKey(String keyId) {
        Objects.requireNonNull(keyId);
        return this.signingKeys.get(keyId);
    }
}

