/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.impl.DefaultClaimsBuilder;
import io.jsonwebtoken.impl.DefaultJwtBuilder;
import io.jsonwebtoken.impl.DefaultJwtHeaderBuilder;
import io.jsonwebtoken.impl.DefaultJwtParserBuilder;
import io.jsonwebtoken.impl.compression.DeflateCompressionAlgorithm;
import io.jsonwebtoken.impl.compression.GzipCompressionAlgorithm;
import io.jsonwebtoken.impl.io.StandardCompressionAlgorithms;
import io.jsonwebtoken.impl.security.DefaultDynamicJwkBuilder;
import io.jsonwebtoken.impl.security.DefaultJwkParserBuilder;
import io.jsonwebtoken.impl.security.DefaultJwkSetBuilder;
import io.jsonwebtoken.impl.security.DefaultJwkSetParserBuilder;
import io.jsonwebtoken.impl.security.DefaultKeyOperationBuilder;
import io.jsonwebtoken.impl.security.DefaultKeyOperationPolicyBuilder;
import io.jsonwebtoken.impl.security.JwksBridge;
import io.jsonwebtoken.impl.security.StandardCurves;
import io.jsonwebtoken.impl.security.StandardEncryptionAlgorithms;
import io.jsonwebtoken.impl.security.StandardHashAlgorithms;
import io.jsonwebtoken.impl.security.StandardKeyAlgorithms;
import io.jsonwebtoken.impl.security.StandardKeyOperations;
import io.jsonwebtoken.impl.security.StandardSecureDigestAlgorithms;
import io.jsonwebtoken.jackson.io.JacksonDeserializer;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import io.jsonwebtoken.lang.NestedCollection;
import io.jsonwebtoken.security.DynamicJwkBuilder;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.JwkSet;
import io.jsonwebtoken.security.JwkSetBuilder;
import io.jsonwebtoken.security.Jwks;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SecurityException;
import io.quarkus.runtime.annotations.RegisterForReflection;
import io.vertx.core.Vertx;
import java.security.Key;
import java.security.PublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.SecretKey;
import org.eclipse.hono.auth.Authorities;
import org.eclipse.hono.service.auth.AuthTokenFactory;
import org.eclipse.hono.service.auth.JwtSupport;
import org.eclipse.hono.service.auth.SignatureSupportingConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterForReflection(targets={DefaultClaimsBuilder.class, DefaultJwtBuilder.class, DefaultJwtHeaderBuilder.class, DefaultJwtParserBuilder.class, DeflateCompressionAlgorithm.class, GzipCompressionAlgorithm.class, StandardCompressionAlgorithms.class, DefaultDynamicJwkBuilder.class, DefaultJwkParserBuilder.class, DefaultJwkSetBuilder.class, DefaultJwkSetParserBuilder.class, DefaultKeyOperationBuilder.class, DefaultKeyOperationPolicyBuilder.class, JwksBridge.class, StandardCurves.class, StandardEncryptionAlgorithms.class, StandardHashAlgorithms.class, StandardKeyAlgorithms.class, StandardKeyOperations.class, StandardSecureDigestAlgorithms.class, JacksonDeserializer.class, JacksonSerializer.class})
public final class JjwtBasedAuthTokenFactory
extends JwtSupport
implements AuthTokenFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JjwtBasedAuthTokenFactory.class);
    private final JwkSet jwkSet;
    private final SignatureSupportingConfigProperties config;
    private final Duration tokenLifetime;
    private final String signingKeyId;

    public JjwtBasedAuthTokenFactory(Vertx vertx, SignatureSupportingConfigProperties config) {
        super(vertx);
        Objects.requireNonNull(config);
        try {
            if (config.getSharedSecret() != null) {
                byte[] bytes = JjwtBasedAuthTokenFactory.getBytes(config.getSharedSecret());
                SecretKey secretKey = Keys.hmacShaKeyFor((byte[])bytes);
                this.signingKeyId = this.addSecretKey(secretKey);
                LOG.info("using shared secret [{} bytes] for signing/validating tokens", (Object)bytes.length);
            } else if (config.getKeyPath() != null && config.getCertPath() != null) {
                this.signingKeyId = this.addPrivateKey(config.getKeyPath(), config.getCertPath());
                LOG.info("using key pair [private: {}, cert: {}] for signing/verifying tokens", (Object)config.getKeyPath(), (Object)config.getCertPath());
            } else {
                throw new IllegalArgumentException("configuration does not specify any key material for signing tokens");
            }
            this.tokenLifetime = Duration.ofSeconds(config.getTokenExpiration());
            LOG.info("using token lifetime of {} seconds", (Object)this.tokenLifetime.getSeconds());
            this.config = config;
            this.jwkSet = this.createJwkSet();
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("failed to create factory for configured key material", e);
        }
    }

    @Override
    public Duration getTokenLifetime() {
        return this.tokenLifetime;
    }

    private JwkSet createJwkSet() {
        JwkSetBuilder jwkSetBuilder = Jwks.set();
        this.getValidatingKeys().stream().mapMulti((entry, consumer) -> {
            Key key = (Key)entry.getValue();
            DynamicJwkBuilder builder = (DynamicJwkBuilder)((NestedCollection)((DynamicJwkBuilder)Jwks.builder().id((String)entry.getKey())).operations().add((Object)Jwks.OP.VERIFY)).and();
            if (key instanceof SecretKey) {
                SecretKey secretKey = (SecretKey)key;
                consumer.accept((Jwk)builder.key(secretKey).build());
            } else if (key instanceof PublicKey) {
                PublicKey publicKey = (PublicKey)key;
                consumer.accept((Jwk)builder.key(publicKey).build());
            }
        }).forEach(arg_0 -> ((JwkSetBuilder)jwkSetBuilder).add(arg_0));
        JwkSet jwkSet = (JwkSet)jwkSetBuilder.build();
        LOG.info("successfully created JWK set containing {} keys", (Object)jwkSet.size());
        return jwkSet;
    }

    @Override
    public String createToken(String authorizationId, Authorities authorities) {
        Objects.requireNonNull(authorizationId);
        Key signingKey = this.getSigningKey(this.signingKeyId);
        JwtBuilder builder = ((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().header().keyId(this.signingKeyId)).and()).issuer(this.config.getIssuer()).subject(authorizationId).expiration(Date.from(Instant.now().plus(this.tokenLifetime))).signWith(signingKey);
        Optional.ofNullable(authorities).map(Authorities::asMap).ifPresent(arg_0 -> ((JwtBuilder)builder).claims(arg_0));
        Optional.ofNullable(this.config.getAudience()).ifPresent(aud -> builder.audience().add(aud));
        return builder.compact();
    }

    @Override
    public JwkSet getValidatingJwkSet() {
        return this.jwkSet;
    }
}

