/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public final class DeploymentHealthCheck
implements HealthCheck,
Handler<AsyncResult<Map<String, String>>> {
    private static final String NAME = "Vert.x deployment";
    private static final HealthCheckResponse INITIAL_RESPONSE = HealthCheckResponse.builder().name("Vert.x deployment").down().build();
    private final AtomicReference<HealthCheckResponse> response = new AtomicReference<HealthCheckResponse>(INITIAL_RESPONSE);

    public void handle(AsyncResult<Map<String, String>> outcome) {
        Objects.requireNonNull(outcome);
        HealthCheckResponseBuilder builder = HealthCheckResponse.builder().name(NAME);
        if (outcome.succeeded()) {
            Optional.ofNullable((Map)outcome.result()).map(Map::entrySet).map(Collection::stream).ifPresent(s -> s.forEach(entry -> builder.withData((String)entry.getKey(), (String)entry.getValue())));
            builder.up();
        } else {
            builder.withData("error deploying component instance(s)", outcome.cause().getMessage());
            builder.down();
        }
        if (!this.response.compareAndSet(INITIAL_RESPONSE, builder.build())) {
            throw new IllegalStateException("deployment outcome has already been reported");
        }
    }

    public HealthCheckResponse call() {
        return this.response.get();
    }
}

