/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.eclipse.hono.service.auth.SignatureSupportingOptions;

public class SignatureSupportingConfigProperties {
    private String sharedSecret = null;
    private String keyPath = null;
    private long tokenExpiration = 600L;
    private String certPath = null;
    private String issuer = "https://hono.eclipse.org/auth-server";
    private String audience;

    public SignatureSupportingConfigProperties() {
    }

    public SignatureSupportingConfigProperties(SignatureSupportingOptions options) {
        options.audience().ifPresent(this::setAudience);
        this.issuer = options.issuer();
        this.certPath = options.certPath().orElse(null);
        this.keyPath = options.keyPath().orElse(null);
        options.sharedSecret().ifPresent(this::setSharedSecret);
        this.setTokenExpiration(options.tokenExpiration());
    }

    public final String getSharedSecret() {
        return this.sharedSecret;
    }

    public final void setSharedSecret(String secret) {
        if (Objects.requireNonNull(secret).getBytes(StandardCharsets.UTF_8).length < 32) {
            throw new IllegalArgumentException("shared secret must be at least 32 bytes");
        }
        this.sharedSecret = secret;
    }

    public final void setKeyPath(String keyPath) {
        this.keyPath = Objects.requireNonNull(keyPath);
    }

    public final String getKeyPath() {
        return this.keyPath;
    }

    public final long getTokenExpiration() {
        return this.tokenExpiration;
    }

    public final void setTokenExpiration(long seconds) {
        if (seconds <= 0L) {
            throw new IllegalArgumentException("token expiration must be > 0");
        }
        this.tokenExpiration = seconds;
    }

    public final void setCertPath(String certPath) {
        this.certPath = Objects.requireNonNull(certPath);
    }

    public final String getCertPath() {
        return this.certPath;
    }

    public final boolean isAppropriateForCreating() {
        return this.sharedSecret != null || this.keyPath != null && this.certPath != null;
    }

    public final boolean isAppropriateForValidating() {
        return this.sharedSecret != null || this.certPath != null;
    }

    public final void setIssuer(String issuer) {
        this.issuer = Objects.requireNonNull(issuer);
    }

    public final String getIssuer() {
        return this.issuer;
    }

    public final void setAudience(String audience) {
        this.audience = Objects.requireNonNull(audience);
    }

    public final String getAudience() {
        return this.audience;
    }
}

