/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tracing;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.JaegerRemoteSamplerProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import io.quarkus.arc.properties.IfBuildProperty;
import io.quarkus.opentelemetry.runtime.config.TracerRuntimeConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.hono.service.tracing.DropBySpanNamePrefixSampler;
import org.eclipse.hono.service.tracing.RateLimitingSampler;
import org.eclipse.hono.service.tracing.SamplingPrioritySampler;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public final class SamplerProducer {
    static final String PROPERTY_OTEL_SERVICE_NAME = "otel.service.name";
    static final String PROPERTY_OTEL_TRACES_SAMPLER = "otel.traces.sampler";
    static final String PROPERTY_OTEL_TRACES_SAMPLER_ARG = "otel.traces.sampler.arg";
    static final String PROPERTY_QUARKUS_APPLICATION_NAME = "quarkus.application.name";
    private static final Logger LOG = LoggerFactory.getLogger(SamplerProducer.class);
    private static final int DEFAULT_MAX_TRACES_PER_SECOND = 1;
    private static final List<String> EVENT_BUS_ADDRESS_PREFIXES_TO_IGNORE = List.of("notification.", "tenant.timeout", "authentication.in");
    private static final String INVALID_HTTP_REQUEST_SPAN_NAME = "/bad-request";
    private ConfigProperties otelConfig;
    private String serviceName;

    @Inject
    SamplerProducer(@ConfigProperty(name="otel.service.name") Optional<String> otelServiceName, @ConfigProperty(name="otel.traces.sampler") Optional<String> otelTracesSampler, @ConfigProperty(name="otel.traces.sampler.arg") Optional<String> otelTracesSamplerArg, @ConfigProperty(name="quarkus.application.name") String quarkusApplicationName) {
        this.serviceName = otelServiceName.orElse(quarkusApplicationName);
        this.otelConfig = new OtelConfigProperties(otelServiceName.orElse(null), otelTracesSampler.orElse(null), otelTracesSamplerArg.orElse(null));
    }

    @Singleton
    @Produces
    @IfBuildProperty(name="quarkus.opentelemetry.enabled", stringValue="true")
    Resource resource() {
        Attributes attributes = Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)this.serviceName, (AttributeKey)ResourceAttributes.SERVICE_NAMESPACE, (Object)"org.eclipse.hono");
        if (LOG.isDebugEnabled()) {
            LOG.debug("using OTEL resources: {}", (Object)attributes);
        }
        return Resource.create((Attributes)attributes);
    }

    @Singleton
    @Produces
    @IfBuildProperty(name="quarkus.opentelemetry.enabled", stringValue="true")
    Sampler sampler(TracerRuntimeConfig tracerRuntimeConfig) {
        TracerRuntimeConfig.SamplerConfig samplerConfig = tracerRuntimeConfig.sampler;
        if (samplerConfig.parentBased.booleanValue()) {
            LOG.warn("'quarkus.opentelemetry.tracer.sampler.parent-based' set to 'true' - custom Hono Sampler will not be applied to child spans");
        }
        String samplerName = Optional.ofNullable(this.otelConfig.getString(PROPERTY_OTEL_TRACES_SAMPLER)).orElse(samplerConfig.samplerName);
        Sampler sampler = this.getBaseSampler(samplerName, samplerConfig);
        sampler = Sampler.parentBased((Sampler)sampler);
        if (LOG.isInfoEnabled()) {
            LOG.info("using OpenTelemetry Sampler [{}]", (Object)sampler.toString());
        }
        sampler = new SamplingPrioritySampler(sampler);
        ArrayList<String> prefixesOfSpansToDrop = new ArrayList<String>(EVENT_BUS_ADDRESS_PREFIXES_TO_IGNORE);
        prefixesOfSpansToDrop.add(INVALID_HTTP_REQUEST_SPAN_NAME);
        return new DropBySpanNamePrefixSampler(sampler, prefixesOfSpansToDrop);
    }

    private Sampler getBaseSampler(String samplerName, TracerRuntimeConfig.SamplerConfig samplerConfig) {
        switch (samplerName) {
            case "jaeger_remote": 
            case "parentbased_jaeger_remote": {
                return this.jaegerRemoteSampler();
            }
            case "always_on": 
            case "parentbased_always_on": 
            case "on": {
                return Sampler.alwaysOn();
            }
            case "always_off": 
            case "parentbased_always_off": 
            case "off": {
                return Sampler.alwaysOff();
            }
            case "traceidratio": 
            case "parentbased_traceidratio": 
            case "ratio": {
                return this.traceIdRatioBasedSampler(samplerConfig);
            }
            case "rate_limiting": 
            case "parentbased_rate_limiting": 
            case "rate-limiting": {
                return this.rateLimitingSampler();
            }
        }
        LOG.warn("unsupported sampler type [{}], falling back to always_on sampler", (Object)samplerName);
        return Sampler.alwaysOn();
    }

    private Sampler jaegerRemoteSampler() {
        return new JaegerRemoteSamplerProvider().createSampler(this.otelConfig);
    }

    private Sampler traceIdRatioBasedSampler(TracerRuntimeConfig.SamplerConfig samplerConfig) {
        Optional<Double> samplerArg = Optional.ofNullable(this.otelConfig.getString(PROPERTY_OTEL_TRACES_SAMPLER_ARG)).map(s -> {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                LOG.warn("invalid sampler ratio config (will use 1.0)", (Throwable)e);
                return 1.0;
            }
        }).or(() -> samplerConfig.ratio);
        return Sampler.traceIdRatioBased((double)samplerArg.orElse(1.0));
    }

    private RateLimitingSampler rateLimitingSampler() {
        int tracesPerSecond = Optional.ofNullable(this.otelConfig.getString(PROPERTY_OTEL_TRACES_SAMPLER_ARG)).map(s -> {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                LOG.warn("invalid sampler rate-limit config (will use {})", (Object)1, (Object)e);
                return 1;
            }
        }).orElse(1);
        return new RateLimitingSampler(tracesPerSecond);
    }

    static class OtelConfigProperties
    implements ConfigProperties {
        private final String otelServiceName;
        private final String otelTracesSampler;
        private final String otelTracesSamplerArg;

        OtelConfigProperties(String serviceName, String tracesSampler, String tracesSamplerArg) {
            this.otelServiceName = serviceName;
            this.otelTracesSampler = tracesSampler;
            this.otelTracesSamplerArg = tracesSamplerArg;
            LOG.debug("using OTEL configuration [{}: {}, {}: {}]", new Object[]{SamplerProducer.PROPERTY_OTEL_TRACES_SAMPLER, tracesSampler, SamplerProducer.PROPERTY_OTEL_TRACES_SAMPLER_ARG, tracesSamplerArg});
        }

        public String getString(String name) {
            switch (name) {
                case "otel.service.name": {
                    return this.otelServiceName;
                }
                case "otel.traces.sampler": {
                    return this.otelTracesSampler;
                }
            }
            return null;
        }

        public Map<String, String> getMap(String name) {
            switch (name) {
                case "otel.traces.sampler.arg": {
                    return Optional.ofNullable(this.otelTracesSamplerArg).map(s -> {
                        String[] kvPairs;
                        HashMap<String, String> map = new HashMap<String, String>();
                        for (String kv : kvPairs = s.split(",", -1)) {
                            int idx = kv.indexOf("=");
                            if (idx <= 0 || kv.length() <= idx) continue;
                            map.put(kv.substring(0, idx), kv.substring(idx + 1));
                        }
                        return map;
                    }).orElseGet(HashMap::new);
                }
            }
            return Map.of();
        }

        public Long getLong(String name) {
            return null;
        }

        public List<String> getList(String name) {
            return null;
        }

        public Integer getInt(String name) {
            return null;
        }

        public Duration getDuration(String name) {
            return null;
        }

        public Double getDouble(String name) {
            return null;
        }

        public Boolean getBoolean(String name) {
            return null;
        }
    }
}

