/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.SigningKeyResolverAdapter;
import io.jsonwebtoken.impl.DefaultJwtParserBuilder;
import io.jsonwebtoken.impl.compression.DeflateCompressionCodec;
import io.jsonwebtoken.jackson.io.JacksonDeserializer;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SecurityException;
import io.jsonwebtoken.security.SignatureException;
import io.quarkus.runtime.annotations.RegisterForReflection;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.jose.JWK;
import java.security.Key;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.hono.service.auth.AuthTokenValidator;
import org.eclipse.hono.service.auth.JwtSupport;
import org.eclipse.hono.service.auth.SignatureSupportingConfigProperties;
import org.eclipse.hono.service.auth.delegating.AuthenticationServerClientConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterForReflection(targets={DefaultJwtParserBuilder.class, JacksonDeserializer.class, DeflateCompressionCodec.class})
public final class JjwtBasedAuthTokenValidator
extends JwtSupport
implements AuthTokenValidator {
    private static final Logger LOG = LoggerFactory.getLogger(JjwtBasedAuthTokenValidator.class);
    private final SignatureSupportingConfigProperties config;
    private final AtomicLong nextJwksPollingTask = new AtomicLong(-1L);
    private final AtomicBoolean jwksPollingInProgress = new AtomicBoolean(false);
    private HttpClient httpClient;
    private RequestOptions requestOptions;
    private long pollingIntervalMillis = 300000L;
    private boolean isJwksSignatureAlgorithmRequired = true;

    public JjwtBasedAuthTokenValidator(Vertx vertx, SignatureSupportingConfigProperties config) {
        super(vertx);
        Objects.requireNonNull(config);
        this.useConfiguredKeys(config);
        this.config = config;
    }

    public JjwtBasedAuthTokenValidator(Vertx vertx, AuthenticationServerClientConfigProperties authServerClientConfig) {
        super(vertx);
        Objects.requireNonNull(authServerClientConfig);
        try {
            this.useConfiguredKeys(authServerClientConfig.getValidation());
        }
        catch (IllegalArgumentException e) {
            LOG.info("using JWK set retrieved from Authentication service vor validating tokens");
            this.isJwksSignatureAlgorithmRequired = authServerClientConfig.isJwksSignatureAlgorithmRequired();
            this.pollingIntervalMillis = authServerClientConfig.getJwksPollingInterval().toMillis();
            HttpClientOptions clientOptions = new HttpClientOptions().setTrustOptions(authServerClientConfig.getTrustOptions());
            this.httpClient = vertx.createHttpClient(clientOptions);
            this.requestOptions = new RequestOptions().setHost(authServerClientConfig.getHost()).setPort(Integer.valueOf(authServerClientConfig.getJwksEndpointPort())).setSsl(Boolean.valueOf(authServerClientConfig.isJwksEndpointTlsEnabled())).setURI(authServerClientConfig.getJwksEndpointUri()).setMethod(HttpMethod.GET).addHeader(HttpHeaders.ACCEPT, (CharSequence)"application/jwk-set+json").setTimeout(2000L);
            this.requestJwkSet();
        }
        this.config = authServerClientConfig.getValidation();
    }

    private void useConfiguredKeys(SignatureSupportingConfigProperties config) {
        block4: {
            try {
                if (config.getSharedSecret() != null) {
                    byte[] secret = JjwtBasedAuthTokenValidator.getBytes(config.getSharedSecret());
                    this.addSecretKey(Keys.hmacShaKeyFor((byte[])secret));
                    LOG.info("using shared secret [{} bytes] for validating tokens", (Object)secret.length);
                    break block4;
                }
                if (config.getCertPath() != null) {
                    this.setPublicKey(config.getCertPath());
                    LOG.info("using public key from certificate [{}] for validating tokens", (Object)config.getCertPath());
                    break block4;
                }
                throw new IllegalArgumentException("configuration does not specify any key material for validating tokens");
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("failed to create validator for configured key material", e);
            }
        }
    }

    private void requestJwkSet() {
        if (!this.jwksPollingInProgress.compareAndSet(false, true)) {
            return;
        }
        this.vertx.cancelTimer(this.nextJwksPollingTask.get());
        LOG.debug("requesting JWK set from http{}://{}:{}{}", new Object[]{this.requestOptions.isSsl() != false ? "s" : "", this.requestOptions.getHost(), this.requestOptions.getPort(), this.requestOptions.getURI()});
        this.httpClient.request(this.requestOptions).compose(HttpClientRequest::send).compose(HttpClientResponse::body).map(Buffer::toJsonObject).map(json -> {
            JsonArray keys;
            if (LOG.isDebugEnabled()) {
                LOG.debug("server returned JWK set:{}{}", (Object)System.lineSeparator(), (Object)json.encodePrettily());
            }
            if ((keys = json.getJsonArray("keys", new JsonArray())).isEmpty()) {
                LOG.warn("server returned empty key set, won't be able to validate tokens");
            }
            return keys;
        }).onSuccess(jwkSet -> {
            HashMap<String, JwtSupport.KeySpec> keys = new HashMap<String, JwtSupport.KeySpec>();
            jwkSet.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).forEach(json -> {
                if (this.isJwksSignatureAlgorithmRequired && !json.containsKey("alg")) {
                    LOG.warn("JSON Web Key does not contain required alg property, skipping key ...");
                } else {
                    try {
                        JWK jwk = new JWK(json);
                        keys.put(jwk.getId(), new JwtSupport.KeySpec((Key)jwk.publicKey(), jwk.getAlgorithm()));
                    }
                    catch (Exception e) {
                        LOG.warn("failed to deserialize JSON Web Key retrieved from server", e.getCause());
                    }
                }
            });
            this.setValidatingKeys(keys);
            LOG.debug("successfully retrieved JWK set of {} key(s)", (Object)keys.size());
            this.nextJwksPollingTask.set(this.vertx.setTimer(this.pollingIntervalMillis, tid -> this.requestJwkSet()));
        }).onFailure(t -> {
            LOG.warn("failed to retrieve JWK set from server, will try again in 3s ...", t);
            this.nextJwksPollingTask.set(this.vertx.setTimer(3000L, tid -> this.requestJwkSet()));
        }).onComplete(ar -> this.jwksPollingInProgress.set(false));
    }

    private Key getValidatingKey(String keyId, String algorithmName) {
        if (keyId == null) {
            LOG.debug("token has no kid header, will try to use default key for validating signature");
            JwtSupport.KeySpec keySpec = this.getValidatingKey();
            if (keySpec.supportsSignatureAlgorithm(algorithmName)) {
                return keySpec.key;
            }
            throw new InvalidKeyException("validating key on record does not support signature algorithm [%s] used in token".formatted(algorithmName));
        }
        JwtSupport.KeySpec keySpec = this.getValidatingKey(keyId);
        if (keySpec == null) {
            LOG.debug("unknown validating key [id: {}]", (Object)keyId);
            this.requestJwkSet();
            throw new InvalidKeyException("unknown validating key");
        }
        if (keySpec.supportsSignatureAlgorithm(algorithmName)) {
            LOG.debug("using key [id: {}] to validate signature (alg: {}]", (Object)keyId, (Object)algorithmName);
            return keySpec.key;
        }
        throw new InvalidKeyException("validating key on record [id: %s] does not support signature\nalgorithm [%s] used in token".formatted(keyId, algorithmName));
    }

    @Override
    public Jws<Claims> expand(String token) {
        Objects.requireNonNull(token);
        JwtParserBuilder builder = Jwts.parserBuilder().requireIssuer(this.config.getIssuer()).setSigningKeyResolver((SigningKeyResolver)new SigningKeyResolverAdapter(){

            public Key resolveSigningKey(JwsHeader header, Claims claims) {
                String algorithmName = Optional.ofNullable(header.getAlgorithm()).orElseThrow(() -> new SignatureException("token does not contain required alg header"));
                String keyId = header.getKeyId();
                return JjwtBasedAuthTokenValidator.this.getValidatingKey(keyId, algorithmName);
            }
        });
        Optional.ofNullable(this.config.getAudience()).ifPresent(arg_0 -> ((JwtParserBuilder)builder).requireAudience(arg_0));
        return builder.build().parseClaimsJws(token);
    }
}

