/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tracing;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;

public class DropBySpanNamePrefixSampler
implements Sampler {
    private final Sampler sampler;
    private final List<String> spanNamePrefixList;

    public DropBySpanNamePrefixSampler(Sampler sampler, List<String> spanNamePrefixList) {
        this.sampler = sampler;
        this.spanNamePrefixList = spanNamePrefixList;
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String spanName, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        for (String spanNamePrefix : this.spanNamePrefixList) {
            if (!spanName.startsWith(spanNamePrefix)) continue;
            return SamplingResult.drop();
        }
        return this.sampler.shouldSample(parentContext, traceId, spanName, spanKind, attributes, parentLinks);
    }

    public String getDescription() {
        return this.sampler.getDescription();
    }
}

