/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.amqp;

import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.Objects;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.AbstractRequestResponseEndpoint;
import org.eclipse.hono.util.Lifecycle;

public abstract class AbstractDelegatingRequestResponseEndpoint<S, T extends ServiceConfigProperties>
extends AbstractRequestResponseEndpoint<T> {
    protected S service;

    public AbstractDelegatingRequestResponseEndpoint(Vertx vertx, S service) {
        super(vertx);
        Objects.requireNonNull(service);
        this.logger.debug("using service instance: {}", service);
        this.service = service;
    }

    protected final S getService() {
        return this.service;
    }

    @Override
    protected void doStart(Promise<Void> startPromise) {
        if (this.service instanceof Lifecycle) {
            ((Lifecycle)this.service).start().onComplete(startPromise);
        } else {
            startPromise.complete();
        }
    }

    @Override
    protected void doStop(Promise<Void> stopPromise) {
        if (this.service instanceof Lifecycle) {
            ((Lifecycle)this.service).stop().onComplete(stopPromise);
        } else {
            stopPromise.complete();
        }
    }
}

