/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tracing;

import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.quarkus.opentelemetry.runtime.tracing.TracerRuntimeConfig;
import io.smallrye.config.SmallRyeConfig;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.eclipse.hono.service.tracing.DropBySpanNamePrefixSampler;
import org.eclipse.hono.service.tracing.SamplingPrioritySampler;
import org.eclipse.hono.service.tracing.UriNormalizationUtil;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SamplerProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SamplerProducer.class);
    private static final List<String> EVENT_BUS_ADDRESS_PREFIXES_TO_IGNORE = List.of("notification.", "tenant.timeout", "authentication.in");
    private static final String INVALID_HTTP_REQUEST_SPAN_NAME = "/bad-request";

    @Singleton
    @Produces
    Sampler sampler(TracerRuntimeConfig tracerRuntimeConfig) {
        TracerRuntimeConfig.SamplerConfig samplerConfig = tracerRuntimeConfig.sampler;
        if (!tracerRuntimeConfig.suppressNonApplicationUris) {
            LOG.info("'quarkus.opentelemetry.tracer.suppress-non-application-uris' set to 'false' - will be ignored");
        }
        if (!samplerConfig.parentBased.booleanValue()) {
            LOG.info("'quarkus.opentelemetry.tracer.sampler.parent-based' set to 'false' - will be ignored");
        }
        Sampler sampler = SamplerProducer.getBaseSampler(samplerConfig.samplerName, samplerConfig.ratio);
        sampler = Sampler.parentBased((Sampler)sampler);
        sampler = new SamplingPrioritySampler(sampler);
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        ArrayList<String> prefixesOfSpansToDrop = new ArrayList<String>(SamplerProducer.getNonApplicationUriPaths(config));
        LOG.info("spans for non-application-URI HTTP requests will be dropped; relevant span name prefixes: {}", prefixesOfSpansToDrop);
        prefixesOfSpansToDrop.addAll(EVENT_BUS_ADDRESS_PREFIXES_TO_IGNORE);
        prefixesOfSpansToDrop.add(INVALID_HTTP_REQUEST_SPAN_NAME);
        return new DropBySpanNamePrefixSampler(sampler, prefixesOfSpansToDrop);
    }

    private static Sampler getBaseSampler(String samplerName, Optional<Double> ratio) {
        LOG.info("using OpenTelemetry tracing sampler mode '{}' [ratio {}]", (Object)samplerName, ratio.orElse(null));
        return switch (samplerName) {
            case "on" -> Sampler.alwaysOn();
            case "off" -> Sampler.alwaysOff();
            case "ratio" -> Sampler.traceIdRatioBased((double)ratio.orElse(1.0));
            default -> throw new IllegalArgumentException("Unrecognized value for sampler: " + samplerName);
        };
    }

    static List<String> getNonApplicationUriPaths(SmallRyeConfig config) {
        ArrayList<String> paths = new ArrayList<String>();
        Optional.ofNullable(config.getRawValue("quarkus.http.root-path")).map(path -> UriNormalizationUtil.toURI(path, true)).ifPresent(httpRootPath -> {
            URI nonAppRootPath = UriNormalizationUtil.normalizeWithBase(httpRootPath, config.getRawValue("quarkus.http.non-application-root-path"), true);
            SamplerProducer.addHealthPaths(paths, config, nonAppRootPath);
            Optional.ofNullable(config.getRawValue("quarkus.micrometer.export.prometheus.path")).map(path -> SamplerProducer.resolveNonApplicationPath(nonAppRootPath, path)).ifPresent(paths::add);
        });
        return paths;
    }

    private static void addHealthPaths(List<String> pathsToAddTo, SmallRyeConfig config, URI nonAppRootPath) {
        Optional.ofNullable(config.getRawValue("quarkus.smallrye-health.root-path")).map(path -> SamplerProducer.resolveNonApplicationPath(nonAppRootPath, path)).ifPresent(healthRootPath -> {
            Optional.ofNullable(config.getRawValue("quarkus.smallrye-health.liveness-path")).map(subPath -> SamplerProducer.resolveNestedNonApplicationPath(nonAppRootPath, healthRootPath, subPath)).ifPresent(pathsToAddTo::add);
            Optional.ofNullable(config.getRawValue("quarkus.smallrye-health.readiness-path")).map(subPath -> SamplerProducer.resolveNestedNonApplicationPath(nonAppRootPath, healthRootPath, subPath)).ifPresent(pathsToAddTo::add);
            Optional.ofNullable(config.getRawValue("quarkus.smallrye-health.startup-path")).map(subPath -> SamplerProducer.resolveNestedNonApplicationPath(nonAppRootPath, healthRootPath, subPath)).ifPresent(pathsToAddTo::add);
        });
    }

    private static String resolveNonApplicationPath(URI nonAppRootPath, String path) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException("Specified path can not be empty");
        }
        return UriNormalizationUtil.normalizeWithBase(nonAppRootPath, path, false).getPath();
    }

    private static String resolveNestedNonApplicationPath(URI nonAppRootPath, String path, String subRoute) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException("Specified path can not be empty");
        }
        URI base = UriNormalizationUtil.normalizeWithBase(nonAppRootPath, path, true);
        return UriNormalizationUtil.normalizeWithBase(base, subRoute, false).getPath();
    }
}

