/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.impl.DefaultJwtBuilder;
import io.jsonwebtoken.impl.DefaultJwtParserBuilder;
import io.jsonwebtoken.impl.compression.DeflateCompressionCodec;
import io.jsonwebtoken.impl.compression.GzipCompressionCodec;
import io.jsonwebtoken.jackson.io.JacksonDeserializer;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import io.quarkus.runtime.annotations.RegisterForReflection;
import io.vertx.core.Vertx;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import org.eclipse.hono.auth.Authorities;
import org.eclipse.hono.config.SignatureSupportingConfigProperties;
import org.eclipse.hono.service.auth.AuthTokenHelper;
import org.eclipse.hono.util.JwtHelper;

@RegisterForReflection(targets={DefaultJwtBuilder.class, DefaultJwtParserBuilder.class, JacksonDeserializer.class, JacksonSerializer.class, DeflateCompressionCodec.class, GzipCompressionCodec.class})
public class AuthTokenHelperImpl
extends JwtHelper
implements AuthTokenHelper {
    private AuthTokenHelperImpl() {
        this(null);
    }

    private AuthTokenHelperImpl(Vertx vertx) {
        super(vertx);
    }

    public static AuthTokenHelper forSigning(Vertx vertx, SignatureSupportingConfigProperties config) {
        return (AuthTokenHelper)JwtHelper.forSigning((SignatureSupportingConfigProperties)config, () -> new AuthTokenHelperImpl(vertx));
    }

    public static AuthTokenHelper forValidating(Vertx vertx, SignatureSupportingConfigProperties config) {
        return (AuthTokenHelper)JwtHelper.forValidating((SignatureSupportingConfigProperties)config, () -> new AuthTokenHelperImpl(vertx));
    }

    public static AuthTokenHelper forSharedSecret(String sharedSecret, long tokenExpirationSeconds) {
        return (AuthTokenHelper)JwtHelper.forSharedSecret((String)sharedSecret, (long)tokenExpirationSeconds, AuthTokenHelperImpl::new);
    }

    @Override
    public String createToken(String authorizationId, Authorities authorities) {
        JwtBuilder builder = Jwts.builder().signWith(this.key, this.algorithm).setIssuer("Hono").setSubject(Objects.requireNonNull(authorizationId)).setExpiration(Date.from(Instant.now().plus(this.tokenLifetime)));
        if (authorities != null) {
            authorities.asMap().forEach((key, value) -> builder.claim(key, value));
        }
        return builder.compact();
    }

    @Override
    public Jws<Claims> expand(String token) {
        Objects.requireNonNull(token);
        return Jwts.parserBuilder().setSigningKey(this.key).build().parseClaimsJws(token);
    }
}

