/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.micrometer.core.instrument.MeterRegistry;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.cpu.CpuCoreSensor;
import io.vertx.core.json.impl.JsonUtil;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.hono.service.ApplicationConfigProperties;
import org.eclipse.hono.service.ComponentNameProvider;
import org.eclipse.hono.service.DeploymentHealthCheck;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.SmallRyeHealthCheckServer;
import org.eclipse.microprofile.health.Readiness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceApplication
implements ComponentNameProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractServiceApplication.class);
    @Inject
    protected Vertx vertx;
    @Inject
    protected MeterRegistry meterRegistry;
    @Inject
    protected SmallRyeHealthCheckServer healthCheckServer;
    @Inject
    protected ApplicationConfigProperties appConfig;
    @Inject
    @Readiness
    protected DeploymentHealthCheck deploymentCheck;

    protected void logJvmDetails() {
        if (LOG.isInfoEnabled()) {
            String base64Encoder = Base64.getEncoder() == JsonUtil.BASE64_ENCODER ? "legacy" : "URL safe";
            LOG.info("running on Java VM [version: {}, name: {}, vendor: {}, max memory: {}MiB, processors: {}] with vert.x using {} Base64 encoder\n", new Object[]{System.getProperty("java.version"), System.getProperty("java.vm.name"), System.getProperty("java.vm.vendor"), Runtime.getRuntime().maxMemory() >> 20, CpuCoreSensor.availableProcessors(), base64Encoder});
        }
    }

    @Deprecated
    protected final void registerHealthchecks(HealthCheckProvider provider) {
        Optional.ofNullable(provider).ifPresent(p -> {
            LOG.debug("registering legacy health checks [provider: {}]", (Object)p.getClass().getName());
            this.healthCheckServer.registerHealthCheckResources((HealthCheckProvider)p);
        });
    }

    @Deprecated
    protected final void registerHealthCheckProvider(Object obj) {
        if (obj instanceof HealthCheckProvider) {
            this.registerHealthchecks((HealthCheckProvider)obj);
        }
    }

    private void registerVertxCloseHook() {
        Vertx vertx = this.vertx;
        if (vertx instanceof VertxInternal) {
            VertxInternal vertxInternal = (VertxInternal)vertx;
            vertxInternal.addCloseHook(completion -> {
                StringBuilder b = new StringBuilder("managed vert.x instance has been closed");
                if (LOG.isDebugEnabled()) {
                    StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                    String s = Arrays.stream(stackTrace).map(element -> "\tat %s.%s(%s:%d)".formatted(element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber())).collect(Collectors.joining(System.lineSeparator()));
                    b.append(System.lineSeparator()).append(s);
                }
                LOG.info(b.toString());
                completion.complete();
            });
        } else {
            LOG.debug("Vertx instance is not a VertxInternal, skipping close hook registration");
        }
    }

    public void onStart(@Observes StartupEvent ev) {
        this.logJvmDetails();
        this.registerVertxCloseHook();
        this.doStart();
    }

    protected void doStart() {
    }

    public void onStop(@Observes ShutdownEvent ev) {
        LOG.info("shutting down {}", (Object)this.getComponentName());
        CompletableFuture shutdown = new CompletableFuture();
        this.vertx.close(attempt -> {
            if (attempt.succeeded()) {
                shutdown.complete(null);
            } else {
                shutdown.completeExceptionally(attempt.cause());
            }
        });
        shutdown.join();
    }
}

