/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.service.http.TracingHandler;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.Strings;
import org.eclipse.hono.util.TelemetryExecutionContext;

public final class HttpContext
implements TelemetryExecutionContext {
    private static final String URI_PREFIX_EVENT = "/event";
    private static final String URI_PREFIX_EVENT_SHORT = "/e";
    private final RoutingContext routingContext;
    private final boolean eventEndpoint;
    private final QoS requestedQos;

    private HttpContext(RoutingContext routingContext) {
        this.routingContext = Objects.requireNonNull(routingContext);
        this.eventEndpoint = Optional.ofNullable(routingContext.request().uri()).map(uri -> uri.startsWith(URI_PREFIX_EVENT) || uri.startsWith(URI_PREFIX_EVENT_SHORT)).orElse(false);
        this.requestedQos = this.determineRequestedQos(routingContext);
    }

    private QoS determineRequestedQos(RoutingContext context) {
        int qosLevel;
        String qos = context.request().getHeader("QoS-Level");
        if (Strings.isNullOrEmpty((Object)qos)) {
            if (this.isEventEndpoint()) {
                return QoS.AT_LEAST_ONCE;
            }
            return QoS.AT_MOST_ONCE;
        }
        try {
            qosLevel = Integer.parseInt(qos);
        }
        catch (NumberFormatException e) {
            return null;
        }
        switch (qosLevel) {
            case 0: {
                return QoS.AT_MOST_ONCE;
            }
            case 1: {
                return QoS.AT_LEAST_ONCE;
            }
        }
        return null;
    }

    public static HttpContext from(RoutingContext routingContext) {
        return new HttpContext(routingContext);
    }

    public RoutingContext getRoutingContext() {
        return this.routingContext;
    }

    public <T> T get(String key) {
        return (T)this.routingContext.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        Object value = this.routingContext.get(key);
        return (T)(value != null ? value : defaultValue);
    }

    public void put(String key, Object value) {
        this.routingContext.put(key, value);
    }

    public SpanContext getTracingContext() {
        return Optional.ofNullable(this.getTracingSpan()).map(Span::context).orElse(null);
    }

    public Span getTracingSpan() {
        Object spanObject = this.routingContext.get(TracingHandler.CURRENT_SPAN);
        return spanObject instanceof Span ? (Span)spanObject : null;
    }

    public QoS getRequestedQos() {
        return this.requestedQos;
    }

    public boolean hasValidQoS() {
        if (this.isEventEndpoint()) {
            return this.requestedQos == QoS.AT_LEAST_ONCE;
        }
        return this.requestedQos != null;
    }

    public HttpServerRequest request() {
        return this.routingContext.request();
    }

    public HttpServerResponse response() {
        return this.routingContext.response();
    }

    public void fail(Throwable throwable) {
        this.routingContext.fail(throwable);
    }

    public String getContentType() {
        String contentType = this.routingContext.parsedHeaders().contentType().value();
        return Strings.isNullOrEmpty((Object)contentType) ? null : contentType;
    }

    private boolean isEventEndpoint() {
        return this.eventEndpoint;
    }

    public Optional<Duration> getTimeToLive() {
        if (!this.isEventEndpoint()) {
            return Optional.empty();
        }
        try {
            Duration ttl = Optional.ofNullable(this.routingContext.request().getHeader("hono-ttl")).map(Long::parseLong).map(Duration::ofSeconds).orElseGet(() -> Optional.ofNullable(this.routingContext.request().getParam("hono-ttl")).map(Long::parseLong).map(Duration::ofSeconds).orElse(null));
            return Optional.ofNullable(ttl);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public Device getAuthenticatedDevice() {
        return Optional.ofNullable(this.routingContext.user()).map(user -> {
            if (DeviceUser.class.isInstance(user)) {
                return (Device)user;
            }
            return null;
        }).orElse(null);
    }

    public Integer getTimeTillDisconnect() {
        try {
            Optional<String> timeTilDisconnectHeader = Optional.ofNullable(this.request().getHeader("hono-ttd"));
            if (timeTilDisconnectHeader.isEmpty()) {
                timeTilDisconnectHeader = Optional.ofNullable(this.request().getParam("hono-ttd"));
            }
            if (timeTilDisconnectHeader.isPresent()) {
                return Integer.parseInt(timeTilDisconnectHeader.get());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public MetricsTags.TtdStatus getTtdStatus() {
        return Optional.ofNullable((MetricsTags.TtdStatus)((Object)this.routingContext.get(MetricsTags.TtdStatus.class.getName()))).orElse(MetricsTags.TtdStatus.NONE);
    }

    public String getOrigAddress() {
        return this.routingContext.request().uri();
    }
}

