/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.eclipse.hono.service.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.service.auth.device.ExecutionContextAuthHandler;
import org.eclipse.hono.service.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.service.http.HttpContext;

public class HttpAuthProviderAdapter
implements AuthProvider {
    static final String AUTH_PROVIDER_CONTEXT_KEY = "io.vertx.ext.web.handler.AuthHandler.provider";
    private final DeviceCredentialsAuthProvider<?> wrappedProvider;
    private final PreCredentialsValidationHandler<HttpContext> preCredentialsValidationHandler;
    private final HttpContext httpContext;

    private HttpAuthProviderAdapter(DeviceCredentialsAuthProvider<?> wrappedProvider, PreCredentialsValidationHandler<HttpContext> preCredentialsValidationHandler, HttpContext httpContext) {
        this.wrappedProvider = wrappedProvider;
        this.preCredentialsValidationHandler = preCredentialsValidationHandler;
        this.httpContext = httpContext;
    }

    public static void putAdaptedProviderInContext(DeviceCredentialsAuthProvider<?> provider, RoutingContext routingContext, PreCredentialsValidationHandler<HttpContext> preCredentialsValidationHandler) {
        Objects.requireNonNull(provider);
        Objects.requireNonNull(routingContext);
        routingContext.put(AUTH_PROVIDER_CONTEXT_KEY, (Object)new HttpAuthProviderAdapter(provider, preCredentialsValidationHandler, HttpContext.from(routingContext)));
    }

    public void authenticate(final JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        ExecutionContextAuthHandler<HttpContext> authHandler = new ExecutionContextAuthHandler<HttpContext>(this.wrappedProvider, this.preCredentialsValidationHandler){

            @Override
            public Future<JsonObject> parseCredentials(HttpContext context) {
                return Future.succeededFuture((Object)authInfo);
            }
        };
        authHandler.authenticateDevice(this.httpContext).onComplete(ar -> {
            if (ar.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture((Object)((User)ar.result())));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }
}

