/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.eclipse.hono.service.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.service.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.service.http.HttpAuthProviderAdapter;
import org.eclipse.hono.service.http.HttpContext;
import org.eclipse.hono.service.http.TracingHandler;
import org.eclipse.hono.tracing.TracingHelper;

public interface HonoHttpAuthHandler {
    public static final String SKIP_POSTPROCESSING_CONTEXT_KEY = HonoHttpAuthHandler.class.getSimpleName() + ".skipPostProcessing";

    public PreCredentialsValidationHandler<HttpContext> getPreCredentialsValidationHandler();

    default public void processParseCredentialsResult(AuthProvider authProvider, RoutingContext routingContext, Tracer tracer, AsyncResult<JsonObject> parseCredentialsResult, Handler<AsyncResult<JsonObject>> handler) {
        Objects.requireNonNull(authProvider);
        Objects.requireNonNull(routingContext);
        Objects.requireNonNull(parseCredentialsResult);
        Objects.requireNonNull(handler);
        if (parseCredentialsResult.succeeded()) {
            Boolean skip = (Boolean)routingContext.get(SKIP_POSTPROCESSING_CONTEXT_KEY);
            if (skip != null && skip.booleanValue()) {
                handler.handle(parseCredentialsResult);
            } else if (authProvider instanceof DeviceCredentialsAuthProvider) {
                HttpAuthProviderAdapter.putAdaptedProviderInContext((DeviceCredentialsAuthProvider)authProvider, routingContext, this.getPreCredentialsValidationHandler());
                handler.handle(parseCredentialsResult);
            } else if (this.getPreCredentialsValidationHandler() != null) {
                handler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("incompatible authProvider used - doesn't support preCredentialsValidationHandler set on the authHandler")));
            } else {
                if (tracer != null) {
                    TracingHelper.injectSpanContext((Tracer)tracer, (SpanContext)TracingHandler.serverSpanContext(routingContext), (JsonObject)((JsonObject)parseCredentialsResult.result()));
                }
                handler.handle(parseCredentialsResult);
            }
        } else {
            handler.handle(parseCredentialsResult);
        }
    }
}

