/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.impl.ChainAuthHandlerImpl;
import org.eclipse.hono.service.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.service.http.AuthHandlerTools;
import org.eclipse.hono.service.http.HonoHttpAuthHandler;
import org.eclipse.hono.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HonoChainAuthHandler
extends ChainAuthHandlerImpl
implements HonoHttpAuthHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HonoChainAuthHandler.class);
    private final PreCredentialsValidationHandler<HttpContext> preCredentialsValidationHandler;

    public HonoChainAuthHandler() {
        this(null);
    }

    public HonoChainAuthHandler(PreCredentialsValidationHandler<HttpContext> preCredentialsValidationHandler) {
        this.preCredentialsValidationHandler = preCredentialsValidationHandler;
    }

    public ChainAuthHandler append(AuthHandler handler) {
        PreCredentialsValidationHandler<HttpContext> nestedPreCredValidationHandler;
        if (handler instanceof HonoHttpAuthHandler && (nestedPreCredValidationHandler = ((HonoHttpAuthHandler)handler).getPreCredentialsValidationHandler()) != null && !nestedPreCredValidationHandler.equals(this.preCredentialsValidationHandler)) {
            LOG.error("{} has PreCredentialsValidationHandler set - not supported in ChainAuthHandler", (Object)handler);
            throw new IllegalArgumentException("handler with a PreCredentialsValidationHandler not supported here");
        }
        return super.append(handler);
    }

    @Override
    public PreCredentialsValidationHandler<HttpContext> getPreCredentialsValidationHandler() {
        return this.preCredentialsValidationHandler;
    }

    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        context.put(SKIP_POSTPROCESSING_CONTEXT_KEY, (Object)Boolean.TRUE);
        super.parseCredentials(context, ar -> {
            if (ar.succeeded()) {
                context.remove(SKIP_POSTPROCESSING_CONTEXT_KEY);
                AuthProvider authProvider = (AuthProvider)context.get("io.vertx.ext.web.handler.AuthHandler.provider");
                this.processParseCredentialsResult(authProvider, context, null, (AsyncResult)ar, (Handler)handler);
            } else {
                handler.handle(ar);
            }
        });
    }

    protected void processException(RoutingContext ctx, Throwable exception) {
        if (!ctx.response().ended()) {
            AuthHandlerTools.processException(ctx, exception, this.authenticateHeader(ctx));
        }
    }
}

