/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.Tracer;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.BasicAuthHandlerImpl;
import io.vertx.ext.web.impl.RoutingContextDecorator;
import java.util.Objects;
import org.eclipse.hono.service.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.service.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.service.http.AuthHandlerTools;
import org.eclipse.hono.service.http.HonoHttpAuthHandler;
import org.eclipse.hono.service.http.HttpContext;
import org.eclipse.hono.service.http.HttpUtils;

public class HonoBasicAuthHandler
extends BasicAuthHandlerImpl
implements HonoHttpAuthHandler {
    private final PreCredentialsValidationHandler<HttpContext> preCredentialsValidationHandler;
    private final Tracer tracer;

    public HonoBasicAuthHandler(AuthProvider authProvider, String realm, Tracer tracer) {
        super(Objects.requireNonNull(authProvider), realm);
        this.tracer = tracer;
        this.preCredentialsValidationHandler = null;
    }

    public HonoBasicAuthHandler(DeviceCredentialsAuthProvider<?> authProvider, String realm) {
        this(authProvider, realm, (PreCredentialsValidationHandler<HttpContext>)null);
    }

    public HonoBasicAuthHandler(DeviceCredentialsAuthProvider<?> authProvider, String realm, PreCredentialsValidationHandler<HttpContext> preCredentialsValidationHandler) {
        super((AuthProvider)Objects.requireNonNull(authProvider), realm);
        this.tracer = null;
        this.preCredentialsValidationHandler = preCredentialsValidationHandler;
    }

    @Override
    public PreCredentialsValidationHandler<HttpContext> getPreCredentialsValidationHandler() {
        return this.preCredentialsValidationHandler;
    }

    protected void processException(RoutingContext ctx, Throwable exception) {
        if (ctx.response().ended()) {
            return;
        }
        AuthHandlerTools.processException(ctx, exception, this.authenticateHeader(ctx));
    }

    public void parseCredentials(final RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        RoutingContextDecorator routingContextDecorator = new RoutingContextDecorator(context.currentRoute(), context){

            public void fail(Throwable throwable) {
                HttpUtils.badRequest(context, "Malformed authorization header");
            }
        };
        super.parseCredentials((RoutingContext)routingContextDecorator, ar -> this.processParseCredentialsResult(this.authProvider, context, this.tracer, (AsyncResult)ar, (Handler)handler));
    }
}

