/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.deviceconnection;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.AbstractDelegatingRequestResponseEndpoint;
import org.eclipse.hono.service.deviceconnection.DeviceConnectionMessageFilter;
import org.eclipse.hono.service.deviceconnection.DeviceConnectionService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.DeviceConnectionConstants;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.RequestResponseResult;
import org.eclipse.hono.util.ResourceIdentifier;

public class DelegatingDeviceConnectionAmqpEndpoint<S extends DeviceConnectionService>
extends AbstractDelegatingRequestResponseEndpoint<S, ServiceConfigProperties> {
    private static final String SPAN_NAME_GET_LAST_GATEWAY = "get last known gateway";
    private static final String SPAN_NAME_SET_LAST_GATEWAY = "set last known gateway";
    private static final String SPAN_NAME_GET_CMD_HANDLING_ADAPTER_INSTANCES = "get command handling adapter instances";
    private static final String SPAN_NAME_SET_CMD_HANDLING_ADAPTER_INSTANCE = "set command handling adapter instance";
    private static final String SPAN_NAME_REMOVE_CMD_HANDLING_ADAPTER_INSTANCE = "remove command handling adapter instance";

    public DelegatingDeviceConnectionAmqpEndpoint(Vertx vertx, S service) {
        super(vertx, service);
    }

    @Override
    protected Future<Message> handleRequestMessage(Message requestMessage, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Objects.requireNonNull(requestMessage);
        Objects.requireNonNull(targetAddress);
        switch (DeviceConnectionConstants.DeviceConnectionAction.from((String)requestMessage.getSubject())) {
            case GET_LAST_GATEWAY: {
                return this.processGetLastGatewayRequest(requestMessage, targetAddress, spanContext);
            }
            case SET_LAST_GATEWAY: {
                return this.processSetLastGatewayRequest(requestMessage, targetAddress, spanContext);
            }
            case GET_CMD_HANDLING_ADAPTER_INSTANCES: {
                return this.processGetCmdHandlingAdapterInstances(requestMessage, targetAddress, spanContext);
            }
            case SET_CMD_HANDLING_ADAPTER_INSTANCE: {
                return this.processSetCmdHandlingAdapterInstance(requestMessage, targetAddress, spanContext);
            }
            case REMOVE_CMD_HANDLING_ADAPTER_INSTANCE: {
                return this.processRemoveCmdHandlingAdapterInstance(requestMessage, targetAddress, spanContext);
            }
        }
        return this.processCustomOperationMessage(requestMessage, spanContext);
    }

    protected Future<Message> processGetLastGatewayRequest(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Future resultFuture;
        String tenantId = targetAddress.getTenantId();
        String deviceId = MessageHelper.getDeviceId((Message)request);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_GET_LAST_GATEWAY, (String)this.getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant and/or device");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            this.log.debug("getting last known gateway for tenant [{}], device [{}]", (Object)tenantId, (Object)deviceId);
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            resultFuture = ((DeviceConnectionService)this.getService()).getLastKnownGatewayForDevice(tenantId, deviceId, span).map(res -> DeviceConnectionConstants.getAmqpReply((String)"device_con", (String)tenantId, (Message)request, (RequestResponseResult)res));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<Message>)resultFuture);
    }

    protected Future<Message> processSetLastGatewayRequest(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Future resultFuture;
        String tenantId = targetAddress.getTenantId();
        String deviceId = MessageHelper.getDeviceId((Message)request);
        String gatewayId = MessageHelper.getGatewayId((Message)request);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_SET_LAST_GATEWAY, (String)this.getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null || gatewayId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or gateway");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            this.log.debug("setting last known gateway for tenant [{}], device [{}] to {}", new Object[]{tenantId, deviceId, gatewayId});
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            TracingHelper.TAG_GATEWAY_ID.set(span, gatewayId);
            resultFuture = ((DeviceConnectionService)this.getService()).setLastKnownGatewayForDevice(tenantId, deviceId, gatewayId, span).map(res -> DeviceConnectionConstants.getAmqpReply((String)"device_con", (String)tenantId, (Message)request, (RequestResponseResult)res));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<Message>)resultFuture);
    }

    protected Future<Message> processGetCmdHandlingAdapterInstances(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Future resultFuture;
        JsonObject payload;
        String tenantId = targetAddress.getTenantId();
        String deviceId = MessageHelper.getDeviceId((Message)request);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_GET_CMD_HANDLING_ADAPTER_INSTANCES, (String)this.getClass().getSimpleName()).start();
        try {
            payload = MessageHelper.getJsonPayload((Message)request);
        }
        catch (DecodeException e) {
            this.logger.debug("failed to decode AMQP request message", (Throwable)e);
            return this.finishSpanOnFutureCompletion(span, (Future<Message>)Future.failedFuture((Throwable)new ClientErrorException(400, "request message body contains malformed JSON")));
        }
        if (tenantId == null || deviceId == null || payload == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or payload");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            Object gatewaysValue = payload.getValue("gateway-ids");
            if (!(gatewaysValue instanceof JsonArray)) {
                TracingHelper.logError((Span)span, (String)"payload JSON is missing valid 'gateway-ids' field value");
                resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
            } else {
                this.log.debug("getting command handling adapter instances for tenant [{}], device [{}]", (Object)tenantId, (Object)deviceId);
                List list = ((JsonArray)gatewaysValue).getList();
                resultFuture = ((DeviceConnectionService)this.getService()).getCommandHandlingAdapterInstances(tenantId, deviceId, list, span).map(res -> DeviceConnectionConstants.getAmqpReply((String)"device_con", (String)tenantId, (Message)request, (RequestResponseResult)res));
            }
        }
        return this.finishSpanOnFutureCompletion(span, (Future<Message>)resultFuture);
    }

    protected Future<Message> processSetCmdHandlingAdapterInstance(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Future resultFuture;
        String tenantId = targetAddress.getTenantId();
        String deviceId = MessageHelper.getDeviceId((Message)request);
        String adapterInstanceId = (String)MessageHelper.getApplicationProperty((ApplicationProperties)request.getApplicationProperties(), (String)"adapter_instance_id", String.class);
        Integer lifespanSecondsOrNull = (Integer)MessageHelper.getApplicationProperty((ApplicationProperties)request.getApplicationProperties(), (String)"lifespan", Integer.class);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_SET_CMD_HANDLING_ADAPTER_INSTANCE, (String)this.getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null || adapterInstanceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or adapter instance id");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            Duration lifespan = lifespanSecondsOrNull != null ? Duration.ofSeconds(lifespanSecondsOrNull.intValue()) : Duration.ofSeconds(-1L);
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            span.setTag("adapter_instance_id", adapterInstanceId);
            span.setTag("lifespan", (Number)lifespan.getSeconds());
            this.log.debug("setting command handling adapter instance for tenant [{}], device [{}] to {} (lifespan: {}s)", new Object[]{tenantId, deviceId, adapterInstanceId, lifespan.getSeconds()});
            resultFuture = ((DeviceConnectionService)this.getService()).setCommandHandlingAdapterInstance(tenantId, deviceId, adapterInstanceId, lifespan, span).map(res -> DeviceConnectionConstants.getAmqpReply((String)"device_con", (String)tenantId, (Message)request, (RequestResponseResult)res));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<Message>)resultFuture);
    }

    protected Future<Message> processRemoveCmdHandlingAdapterInstance(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Future resultFuture;
        String tenantId = targetAddress.getTenantId();
        String deviceId = MessageHelper.getDeviceId((Message)request);
        String adapterInstanceId = (String)MessageHelper.getApplicationProperty((ApplicationProperties)request.getApplicationProperties(), (String)"adapter_instance_id", String.class);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_REMOVE_CMD_HANDLING_ADAPTER_INSTANCE, (String)this.getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null || adapterInstanceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or adapter instance id");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            span.setTag("adapter_instance_id", adapterInstanceId);
            this.log.debug("removing command handling adapter instance for tenant [{}], device [{}] with value {}", new Object[]{tenantId, deviceId, adapterInstanceId});
            resultFuture = ((DeviceConnectionService)this.getService()).removeCommandHandlingAdapterInstance(tenantId, deviceId, adapterInstanceId, span).map(res -> DeviceConnectionConstants.getAmqpReply((String)"device_con", (String)tenantId, (Message)request, (RequestResponseResult)res));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<Message>)resultFuture);
    }

    protected Future<Message> processCustomOperationMessage(Message request, SpanContext spanContext) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getSubject());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    @Override
    protected boolean passesFormalVerification(ResourceIdentifier linkTarget, Message msg) {
        return DeviceConnectionMessageFilter.verify(linkTarget, msg);
    }

    @Override
    public final String getName() {
        return "device_con";
    }
}

