/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.commandrouter;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.time.Duration;
import java.util.Objects;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.AbstractDelegatingRequestResponseEndpoint;
import org.eclipse.hono.service.commandrouter.CommandRouterMessageFilter;
import org.eclipse.hono.service.commandrouter.CommandRouterService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CommandRouterConstants;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.RequestResponseResult;
import org.eclipse.hono.util.ResourceIdentifier;

public class DelegatingCommandRouterAmqpEndpoint<S extends CommandRouterService>
extends AbstractDelegatingRequestResponseEndpoint<S, ServiceConfigProperties> {
    private static final String SPAN_NAME_SET_LAST_GATEWAY = "set last known gateway";
    private static final String SPAN_NAME_REGISTER_COMMAND_CONSUMER = "register command consumer";
    private static final String SPAN_NAME_UNREGISTER_COMMAND_CONSUMER = "unregister command consumer";

    public DelegatingCommandRouterAmqpEndpoint(Vertx vertx, S service) {
        super(vertx, service);
    }

    @Override
    protected Future<Message> handleRequestMessage(Message requestMessage, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Objects.requireNonNull(requestMessage);
        Objects.requireNonNull(targetAddress);
        switch (CommandRouterConstants.CommandRouterAction.from((String)requestMessage.getSubject())) {
            case SET_LAST_KNOWN_GATEWAY: {
                return this.processSetLastKnownGatewayRequest(requestMessage, targetAddress, spanContext);
            }
            case REGISTER_COMMAND_CONSUMER: {
                return this.processRegisterCommandConsumer(requestMessage, targetAddress, spanContext);
            }
            case UNREGISTER_COMMAND_CONSUMER: {
                return this.processUnregisterCommandConsumer(requestMessage, targetAddress, spanContext);
            }
        }
        return this.processCustomOperationMessage(requestMessage, spanContext);
    }

    protected Future<Message> processSetLastKnownGatewayRequest(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Future resultFuture;
        String tenantId = targetAddress.getTenantId();
        String deviceId = MessageHelper.getDeviceId((Message)request);
        String gatewayId = MessageHelper.getGatewayId((Message)request);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_SET_LAST_GATEWAY, (String)this.getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null || gatewayId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or gateway");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            this.log.debug("setting last known gateway for tenant [{}], device [{}] to {}", new Object[]{tenantId, deviceId, gatewayId});
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            TracingHelper.TAG_GATEWAY_ID.set(span, gatewayId);
            resultFuture = ((CommandRouterService)this.getService()).setLastKnownGatewayForDevice(tenantId, deviceId, gatewayId, span).map(res -> CommandRouterConstants.getAmqpReply((String)"cmd_router", (String)tenantId, (Message)request, (RequestResponseResult)res));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<Message>)resultFuture);
    }

    protected Future<Message> processRegisterCommandConsumer(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Future resultFuture;
        String tenantId = targetAddress.getTenantId();
        String deviceId = MessageHelper.getDeviceId((Message)request);
        String adapterInstanceId = (String)MessageHelper.getApplicationProperty((ApplicationProperties)request.getApplicationProperties(), (String)"adapter_instance_id", String.class);
        Integer lifespanSecondsOrNull = (Integer)MessageHelper.getApplicationProperty((ApplicationProperties)request.getApplicationProperties(), (String)"lifespan", Integer.class);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_REGISTER_COMMAND_CONSUMER, (String)this.getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null || adapterInstanceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or adapter instance id");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            Duration lifespan = lifespanSecondsOrNull != null ? Duration.ofSeconds(lifespanSecondsOrNull.intValue()) : Duration.ofSeconds(-1L);
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            span.setTag("adapter_instance_id", adapterInstanceId);
            span.setTag("lifespan", (Number)lifespan.getSeconds());
            this.log.debug("register command consumer [tenant-id: {}, device-id: {}, adapter-instance-id {}, lifespan: {}s]", new Object[]{tenantId, deviceId, adapterInstanceId, lifespan.getSeconds()});
            resultFuture = ((CommandRouterService)this.getService()).registerCommandConsumer(tenantId, deviceId, adapterInstanceId, lifespan, span).map(res -> CommandRouterConstants.getAmqpReply((String)"cmd_router", (String)tenantId, (Message)request, (RequestResponseResult)res));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<Message>)resultFuture);
    }

    protected Future<Message> processUnregisterCommandConsumer(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Future resultFuture;
        String tenantId = targetAddress.getTenantId();
        String deviceId = MessageHelper.getDeviceId((Message)request);
        String adapterInstanceId = (String)MessageHelper.getApplicationProperty((ApplicationProperties)request.getApplicationProperties(), (String)"adapter_instance_id", String.class);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_UNREGISTER_COMMAND_CONSUMER, (String)this.getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null || adapterInstanceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or adapter instance id");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            span.setTag("adapter_instance_id", adapterInstanceId);
            this.log.debug("unregister command consumer [tenant-id: {}, device-id: {}, adapter-instance-id {}]", new Object[]{tenantId, deviceId, adapterInstanceId});
            resultFuture = ((CommandRouterService)this.getService()).unregisterCommandConsumer(tenantId, deviceId, adapterInstanceId, span).map(res -> CommandRouterConstants.getAmqpReply((String)"cmd_router", (String)tenantId, (Message)request, (RequestResponseResult)res));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<Message>)resultFuture);
    }

    protected Future<Message> processCustomOperationMessage(Message request, SpanContext spanContext) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getSubject());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    @Override
    protected boolean passesFormalVerification(ResourceIdentifier linkTarget, Message msg) {
        return CommandRouterMessageFilter.verify(linkTarget, msg);
    }

    @Override
    public final String getName() {
        return "cmd_router";
    }
}

