/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.service.auth.device.AbstractDeviceCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsernamePasswordCredentials
extends AbstractDeviceCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(UsernamePasswordCredentials.class);
    private String password;

    private UsernamePasswordCredentials(String tenantId, String authId, JsonObject clientContext) {
        super(tenantId, authId, clientContext);
    }

    public static final UsernamePasswordCredentials create(String username, String password) {
        return UsernamePasswordCredentials.create(username, password, new JsonObject());
    }

    public static final UsernamePasswordCredentials create(String username, String password, JsonObject clientContext) {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        Objects.requireNonNull(clientContext);
        String[] userComponents = username.split("@", 2);
        if (userComponents.length != 2) {
            LOG.trace("username [{}] does not comply with expected pattern [<authId>@<tenantId>]", (Object)username);
            return null;
        }
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userComponents[1], userComponents[0], clientContext);
        credentials.password = password;
        return credentials;
    }

    @Override
    public final String getType() {
        return "hashed-password";
    }

    public final String getPassword() {
        return this.password;
    }
}

